/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.blockhash.TimeSeriesBlockHash;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.HashAggregationOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.TimeValue;

public record TimeSeriesAggregationOperatorFactory(AggregatorMode mode, int tsHashChannel, int timestampIntervalChannel, TimeValue timeSeriesPeriod, List<GroupingAggregator.Factory> aggregators, int maxPageSize) implements Operator.OperatorFactory
{
    @Override
    public String describe() {
        return "TimeSeriesAggregationOperator[mode=" + this.mode + ", tsHashChannel = " + this.tsHashChannel + ", timestampIntervalChannel = " + this.timestampIntervalChannel + ", timeSeriesPeriod = " + this.timeSeriesPeriod + ", maxPageSize = " + this.maxPageSize + "]";
    }

    @Override
    public Operator get(DriverContext driverContext) {
        TimeSeriesBlockHash blockHash = new TimeSeriesBlockHash(this.tsHashChannel, this.timestampIntervalChannel, driverContext);
        return new HashAggregationOperator(this.aggregators, () -> blockHash, driverContext);
    }
}

