/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class EvalOperator
extends AbstractPageMappingOperator {
    private final BlockFactory blockFactory;
    private final ExpressionEvaluator evaluator;
    public static final ExpressionEvaluator.Factory CONSTANT_NULL_FACTORY = new ExpressionEvaluator.Factory(){

        @Override
        public ExpressionEvaluator get(final DriverContext driverContext) {
            return new ExpressionEvaluator(){

                @Override
                public Block eval(Page page) {
                    return driverContext.blockFactory().newConstantNullBlock(page.getPositionCount());
                }

                public void close() {
                }
            };
        }

        public String toString() {
            return "ConstantNull";
        }
    };

    public EvalOperator(BlockFactory blockFactory, ExpressionEvaluator evaluator) {
        this.blockFactory = blockFactory;
        this.evaluator = evaluator;
    }

    @Override
    protected Page process(Page page) {
        Block block = this.evaluator.eval(page);
        return page.appendBlock(block);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[evaluator=" + this.evaluator + "]";
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.evaluator, () -> super.close()});
    }

    public static interface ExpressionEvaluator
    extends Releasable {
        public Block eval(Page var1);

        public static interface Factory {
            public ExpressionEvaluator get(DriverContext var1);
        }
    }

    public record EvalOperatorFactory(ExpressionEvaluator.Factory evaluator) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new EvalOperator(driverContext.blockFactory(), this.evaluator.get(driverContext));
        }

        @Override
        public String describe() {
            return "EvalOperator[evaluator=" + this.evaluator + "]";
        }
    }
}

