/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractPageMappingOperator
implements Operator {
    private Page prev;
    private boolean finished = false;
    private long processNanos;
    private int pagesProcessed;

    protected abstract Page process(Page var1);

    public abstract String toString();

    @Override
    public final boolean needsInput() {
        return this.prev == null && !this.finished;
    }

    @Override
    public final void addInput(Page page) {
        assert (this.prev == null) : "has pending input page";
        this.prev = page;
    }

    @Override
    public final void finish() {
        this.finished = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finished && this.prev == null;
    }

    @Override
    public final Page getOutput() {
        if (this.prev == null) {
            return null;
        }
        if (this.prev.getPositionCount() == 0) {
            return this.prev;
        }
        long start = System.nanoTime();
        Page p = this.process(this.prev);
        ++this.pagesProcessed;
        this.processNanos += System.nanoTime() - start;
        this.prev = null;
        return p;
    }

    @Override
    public final Status status() {
        return this.status(this.processNanos, this.pagesProcessed);
    }

    protected Status status(long processNanos, int pagesProcessed) {
        return new Status(processNanos, pagesProcessed);
    }

    @Override
    public void close() {
        if (this.prev != null) {
            Releasables.closeExpectNoException(() -> this.prev.releaseBlocks());
        }
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "page_mapping", Status::new);
        private final long processNanos;
        private final int pagesProcessed;

        public Status(long processNanos, int pagesProcessed) {
            this.processNanos = processNanos;
            this.pagesProcessed = pagesProcessed;
        }

        protected Status(StreamInput in) throws IOException {
            this.processNanos = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_TIMINGS) ? in.readVLong() : 0L;
            this.pagesProcessed = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_TIMINGS)) {
                out.writeVLong(this.processNanos);
            }
            out.writeVInt(this.pagesProcessed);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int pagesProcessed() {
            return this.pagesProcessed;
        }

        public long processNanos() {
            return this.processNanos;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerToXContent(builder);
            return builder.endObject();
        }

        protected final XContentBuilder innerToXContent(XContentBuilder builder) throws IOException {
            builder.field("process_nanos", this.processNanos);
            if (builder.humanReadable()) {
                builder.field("process_time", (Object)TimeValue.timeValueNanos((long)this.processNanos));
            }
            return builder.field("pages_processed", this.pagesProcessed);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.processNanos == status.processNanos && this.pagesProcessed == status.pagesProcessed;
        }

        public int hashCode() {
            return Objects.hash(this.processNanos, this.pagesProcessed);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }
    }
}

