/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class LuceneSourceOperator
extends LuceneOperator {
    private int currentPagePos = 0;
    private int remainingDocs;
    private IntVector.Builder docsBuilder;
    private final LeafCollector leafCollector;
    private final int minPageSize;

    public LuceneSourceOperator(BlockFactory blockFactory, int maxPageSize, LuceneSliceQueue sliceQueue, int limit) {
        super(blockFactory, maxPageSize, sliceQueue);
        this.minPageSize = Math.max(1, maxPageSize / 2);
        this.remainingDocs = limit;
        this.docsBuilder = blockFactory.newIntVectorBuilder(Math.min(limit, maxPageSize));
        this.leafCollector = new LeafCollector(){

            public void setScorer(Scorable scorer) {
            }

            public void collect(int doc) {
                if (LuceneSourceOperator.this.remainingDocs > 0) {
                    --LuceneSourceOperator.this.remainingDocs;
                    LuceneSourceOperator.this.docsBuilder.appendInt(doc);
                    ++LuceneSourceOperator.this.currentPagePos;
                }
            }
        };
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting;
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Page getOutput() {
        if (this.isFinished()) {
            if ($assertionsDisabled) return null;
            if (this.currentPagePos == 0) return null;
            throw new AssertionError(this.currentPagePos);
        }
        long start = System.nanoTime();
        try {
            LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
            if (scorer == null) {
                Page page = null;
                return page;
            }
            scorer.scoreNextRange(this.leafCollector, scorer.leafReaderContext().reader().getLiveDocs(), this.maxPageSize - this.currentPagePos);
            Page page = null;
            if (this.currentPagePos >= this.minPageSize || this.remainingDocs <= 0 || scorer.isDone()) {
                block11: {
                    ++this.pagesEmitted;
                    IntBlock shard = null;
                    IntBlock leaf = null;
                    IntVector docs = null;
                    try {
                        shard = this.blockFactory.newConstantIntBlockWith(scorer.shardContext().index(), this.currentPagePos);
                        leaf = this.blockFactory.newConstantIntBlockWith(scorer.leafReaderContext().ord, this.currentPagePos);
                        docs = this.docsBuilder.build();
                        this.docsBuilder = this.blockFactory.newIntVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                        page = new Page(this.currentPagePos, new DocVector(shard.asVector(), leaf.asVector(), docs, true).asBlock());
                        if (page != null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (page != null) throw throwable;
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs});
                        throw throwable;
                    }
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs});
                }
                this.currentPagePos = 0;
            }
            Page page2 = page;
            return page2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.processingNanos += System.nanoTime() - start;
        }
    }

    @Override
    public void close() {
        this.docsBuilder.close();
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", remainingDocs=").append(this.remainingDocs);
    }

    public static class Factory
    implements LuceneOperator.Factory {
        private final DataPartitioning dataPartitioning;
        private final int taskConcurrency;
        private final int maxPageSize;
        private final int limit;
        private final LuceneSliceQueue sliceQueue;

        public Factory(List<? extends ShardContext> contexts, Function<ShardContext, Query> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, int maxPageSize, int limit) {
            this.maxPageSize = maxPageSize;
            this.limit = limit;
            this.dataPartitioning = dataPartitioning;
            Function<ShardContext, Weight> weightFunction = LuceneOperator.weightFunction(queryFunction, ScoreMode.COMPLETE_NO_SCORES);
            this.sliceQueue = LuceneSliceQueue.create(contexts, weightFunction, dataPartitioning, taskConcurrency);
            this.taskConcurrency = Math.min(this.sliceQueue.totalSlices(), taskConcurrency);
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new LuceneSourceOperator(driverContext.blockFactory(), this.maxPageSize, this.sliceQueue, this.limit);
        }

        @Override
        public int taskConcurrency() {
            return this.taskConcurrency;
        }

        public int maxPageSize() {
            return this.maxPageSize;
        }

        public int limit() {
            return this.limit;
        }

        @Override
        public String describe() {
            return "LuceneSourceOperator[dataPartitioning = " + this.dataPartitioning + ", maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + "]";
        }
    }
}

