/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.lucene.LuceneSlice;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.PartialLeafReaderContext;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class LuceneOperator
extends SourceOperator {
    private static final Logger logger = LogManager.getLogger(LuceneOperator.class);
    public static final int NO_LIMIT = Integer.MAX_VALUE;
    protected final BlockFactory blockFactory;
    private int processedSlices;
    final int maxPageSize;
    private final LuceneSliceQueue sliceQueue;
    private final Set<Query> processedQueries = new HashSet<Query>();
    private final Set<String> processedShards = new HashSet<String>();
    private LuceneSlice currentSlice;
    private int sliceIndex;
    private LuceneScorer currentScorer;
    long processingNanos;
    int pagesEmitted;
    boolean doneCollecting;

    protected LuceneOperator(BlockFactory blockFactory, int maxPageSize, LuceneSliceQueue sliceQueue) {
        this.blockFactory = blockFactory;
        this.maxPageSize = maxPageSize;
        this.sliceQueue = sliceQueue;
    }

    @Override
    public void close() {
    }

    LuceneScorer getCurrentOrLoadNextScorer() {
        while (this.currentScorer == null || this.currentScorer.isDone()) {
            if (this.currentSlice == null || this.sliceIndex >= this.currentSlice.numLeaves()) {
                this.sliceIndex = 0;
                this.currentSlice = this.sliceQueue.nextSlice();
                if (this.currentSlice == null) {
                    this.doneCollecting = true;
                    return null;
                }
                ++this.processedSlices;
                this.processedShards.add(this.currentSlice.shardContext().shardIdentifier());
            }
            PartialLeafReaderContext partialLeaf = this.currentSlice.getLeaf(this.sliceIndex++);
            logger.trace("Starting {}", new Object[]{partialLeaf});
            LeafReaderContext leaf = partialLeaf.leafReaderContext();
            if (this.currentScorer == null || this.currentScorer.leafReaderContext() != leaf) {
                Weight weight = this.currentSlice.weight().get();
                this.processedQueries.add(weight.getQuery());
                this.currentScorer = new LuceneScorer(this.currentSlice.shardContext(), weight, leaf);
            }
            assert (this.currentScorer.maxPosition <= partialLeaf.maxDoc()) : this.currentScorer.maxPosition + ">" + partialLeaf.maxDoc();
            this.currentScorer.maxPosition = partialLeaf.maxDoc();
            this.currentScorer.position = Math.max(this.currentScorer.position, partialLeaf.minDoc());
        }
        if (Thread.currentThread() != this.currentScorer.executingThread) {
            this.currentScorer.reinitialize();
        }
        return this.currentScorer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("maxPageSize=").append(this.maxPageSize);
        this.describe(sb);
        sb.append("]");
        return sb.toString();
    }

    protected abstract void describe(StringBuilder var1);

    @Override
    public Operator.Status status() {
        return new Status(this);
    }

    static Function<ShardContext, Weight> weightFunction(Function<ShardContext, Query> queryFunction, ScoreMode scoreMode) {
        return ctx -> {
            Query query = (Query)queryFunction.apply((ShardContext)ctx);
            IndexSearcher searcher = ctx.searcher();
            try {
                return searcher.createWeight(searcher.rewrite((Query)new ConstantScoreQuery(query)), scoreMode, 1.0f);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    static final class LuceneScorer {
        private final ShardContext shardContext;
        private final Weight weight;
        private final LeafReaderContext leafReaderContext;
        private BulkScorer bulkScorer;
        private int position;
        private int maxPosition;
        private Thread executingThread;

        LuceneScorer(ShardContext shardContext, Weight weight, LeafReaderContext leafReaderContext) {
            this.shardContext = shardContext;
            this.weight = weight;
            this.leafReaderContext = leafReaderContext;
            this.reinitialize();
        }

        private void reinitialize() {
            this.executingThread = Thread.currentThread();
            try {
                this.bulkScorer = this.weight.bulkScorer(this.leafReaderContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        void scoreNextRange(LeafCollector collector, Bits acceptDocs, int numDocs) throws IOException {
            assert (!this.isDone()) : "scorer is exhausted";
            numDocs = Math.min(this.maxPosition - this.position, numDocs);
            assert (numDocs > 0) : "scorer was exhausted";
            this.position = this.bulkScorer.score(collector, acceptDocs, this.position, Math.min(this.maxPosition, this.position + numDocs));
        }

        LeafReaderContext leafReaderContext() {
            return this.leafReaderContext;
        }

        boolean isDone() {
            return this.bulkScorer == null || this.position >= this.maxPosition;
        }

        void markAsDone() {
            this.position = Integer.MAX_VALUE;
        }

        ShardContext shardContext() {
            return this.shardContext;
        }

        Weight weight() {
            return this.weight;
        }

        int position() {
            return this.position;
        }
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "lucene_source", Status::new);
        private final int processedSlices;
        private final Set<String> processedQueries;
        private final Set<String> processedShards;
        private final long processingNanos;
        private final int totalSlices;
        private final int pagesEmitted;
        private final int sliceIndex;
        private final int sliceMin;
        private final int sliceMax;
        private final int current;

        private Status(LuceneOperator operator) {
            this.processedSlices = operator.processedSlices;
            this.processedQueries = operator.processedQueries.stream().map(Query::toString).collect(Collectors.toCollection(TreeSet::new));
            this.processingNanos = operator.processingNanos;
            this.processedShards = new TreeSet<String>(operator.processedShards);
            this.sliceIndex = operator.sliceIndex;
            this.totalSlices = operator.sliceQueue.totalSlices();
            LuceneSlice slice = operator.currentSlice;
            if (slice != null && this.sliceIndex < slice.numLeaves()) {
                PartialLeafReaderContext leaf = slice.getLeaf(this.sliceIndex);
                this.sliceMin = leaf.minDoc();
                this.sliceMax = leaf.maxDoc();
            } else {
                this.sliceMin = 0;
                this.sliceMax = 0;
            }
            LuceneScorer scorer = operator.currentScorer;
            this.current = scorer == null ? 0 : scorer.position;
            this.pagesEmitted = operator.pagesEmitted;
        }

        Status(int processedSlices, Set<String> processedQueries, Set<String> processedShards, long processingNanos, int sliceIndex, int totalSlices, int pagesEmitted, int sliceMin, int sliceMax, int current) {
            this.processedSlices = processedSlices;
            this.processedQueries = processedQueries;
            this.processedShards = processedShards;
            this.processingNanos = processingNanos;
            this.sliceIndex = sliceIndex;
            this.totalSlices = totalSlices;
            this.pagesEmitted = pagesEmitted;
            this.sliceMin = sliceMin;
            this.sliceMax = sliceMax;
            this.current = current;
        }

        Status(StreamInput in) throws IOException {
            this.processedSlices = in.readVInt();
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_STATUS_INCLUDE_LUCENE_QUERIES)) {
                this.processedQueries = in.readCollectionAsSet(StreamInput::readString);
                this.processedShards = in.readCollectionAsSet(StreamInput::readString);
            } else {
                this.processedQueries = Collections.emptySet();
                this.processedShards = Collections.emptySet();
            }
            this.processingNanos = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_TIMINGS) ? in.readVLong() : 0L;
            this.sliceIndex = in.readVInt();
            this.totalSlices = in.readVInt();
            this.pagesEmitted = in.readVInt();
            this.sliceMin = in.readVInt();
            this.sliceMax = in.readVInt();
            this.current = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.processedSlices);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_STATUS_INCLUDE_LUCENE_QUERIES)) {
                out.writeCollection(this.processedQueries, StreamOutput::writeString);
                out.writeCollection(this.processedShards, StreamOutput::writeString);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_TIMINGS)) {
                out.writeVLong(this.processingNanos);
            }
            out.writeVInt(this.sliceIndex);
            out.writeVInt(this.totalSlices);
            out.writeVInt(this.pagesEmitted);
            out.writeVInt(this.sliceMin);
            out.writeVInt(this.sliceMax);
            out.writeVInt(this.current);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int processedSlices() {
            return this.processedSlices;
        }

        public Set<String> processedQueries() {
            return this.processedQueries;
        }

        public Set<String> processedShards() {
            return this.processedShards;
        }

        public long processNanos() {
            return this.processingNanos;
        }

        public int sliceIndex() {
            return this.sliceIndex;
        }

        public int totalSlices() {
            return this.totalSlices;
        }

        public int pagesEmitted() {
            return this.pagesEmitted;
        }

        public int sliceMin() {
            return this.sliceMin;
        }

        public int sliceMax() {
            return this.sliceMax;
        }

        public int current() {
            return this.current;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("processed_slices", this.processedSlices);
            builder.field("processed_queries", this.processedQueries);
            builder.field("processed_shards", this.processedShards);
            builder.field("processing_nanos", this.processingNanos);
            if (builder.humanReadable()) {
                builder.field("processing_time", (Object)TimeValue.timeValueNanos((long)this.processingNanos));
            }
            builder.field("slice_index", this.sliceIndex);
            builder.field("total_slices", this.totalSlices);
            builder.field("pages_emitted", this.pagesEmitted);
            builder.field("slice_min", this.sliceMin);
            builder.field("slice_max", this.sliceMax);
            builder.field("current", this.current);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.processedSlices == status.processedSlices && this.processedQueries.equals(status.processedQueries) && this.processedShards.equals(status.processedShards) && this.processingNanos == status.processingNanos && this.sliceIndex == status.sliceIndex && this.totalSlices == status.totalSlices && this.pagesEmitted == status.pagesEmitted && this.sliceMin == status.sliceMin && this.sliceMax == status.sliceMax && this.current == status.current;
        }

        public int hashCode() {
            return Objects.hash(this.processedSlices, this.sliceIndex, this.totalSlices, this.pagesEmitted, this.sliceMin, this.sliceMax, this.current);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }
    }

    public static interface Factory
    extends SourceOperator.SourceOperatorFactory {
        public int taskConcurrency();
    }
}

