/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class LongVectorBlock
extends AbstractVectorBlock
implements LongBlock {
    private final LongVector vector;

    LongVectorBlock(LongVector vector) {
        this.vector = vector;
    }

    @Override
    public LongVector asVector() {
        return this.vector;
    }

    @Override
    public long getLong(int valueIndex) {
        return this.vector.getLong(valueIndex);
    }

    @Override
    public int getPositionCount() {
        return this.vector.getPositionCount();
    }

    @Override
    public ElementType elementType() {
        return this.vector.elementType();
    }

    @Override
    public LongBlock filter(int ... positions) {
        return this.vector.filter(positions).asBlock();
    }

    @Override
    public LongBlock expand() {
        this.incRef();
        return this;
    }

    public long ramBytesUsed() {
        return this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LongBlock) {
            LongBlock that = (LongBlock)obj;
            return LongBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LongBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[vector=" + this.vector + "]";
    }

    @Override
    public void closeInternal() {
        assert (!this.vector.isReleased()) : "can't release block [" + this + "] containing already released vector";
        Releasables.closeExpectNoException((Releasable)this.vector);
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }
}

