/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongArrayVector;
import org.elasticsearch.compute.data.LongBigArrayVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Vector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LongVector
extends Vector {
    public long getLong(int var1);

    @Override
    public LongBlock asBlock();

    @Override
    public LongVector filter(int ... var1);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(LongVector vector1, LongVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getLong(pos) == vector2.getLong(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(LongVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            long element = vector.getLong(pos);
            result = 31 * result + (int)(element ^ element >>> 32);
        }
        return result;
    }

    public static LongVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> LongVector.readValues(positions, in, blockFactory);
            case 1 -> blockFactory.newConstantLongVector(in.readLong(), positions);
            case 2 -> LongArrayVector.readArrayVector(positions, in, blockFactory);
            case 3 -> LongBigArrayVector.readArrayVector(positions, in, blockFactory);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid vector serialization type [" + serializationType + "]"));
                }
                throw new IllegalStateException("invalid vector serialization type [" + serializationType + "]");
            }
        };
    }

    default public void writeTo(StreamOutput out) throws IOException {
        LongVector longVector;
        int positions = this.getPositionCount();
        TransportVersion version = out.getTransportVersion();
        out.writeVInt(positions);
        if (this.isConstant() && positions > 0) {
            out.writeByte((byte)1);
            out.writeLong(this.getLong(0));
        } else if (version.onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_ARRAY_VECTOR) && (longVector = this) instanceof LongArrayVector) {
            LongArrayVector v = (LongArrayVector)longVector;
            out.writeByte((byte)2);
            v.writeArrayVector(positions, out);
        } else if (version.onOrAfter((VersionId)TransportVersions.ESQL_SERIALIZE_BIG_VECTOR) && (longVector = this) instanceof LongBigArrayVector) {
            LongBigArrayVector v = (LongBigArrayVector)longVector;
            out.writeByte((byte)3);
            v.writeArrayVector(positions, out);
        } else {
            out.writeByte((byte)0);
            LongVector.writeValues(this, positions, out);
        }
    }

    private static LongVector readValues(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        try (FixedBuilder builder = blockFactory.newLongVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendLong(in.readLong());
            }
            LongVector longVector = builder.build();
            return longVector;
        }
    }

    private static void writeValues(LongVector v, int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeLong(v.getLong(i));
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FixedBuilder
    extends Builder {
        @Override
        public FixedBuilder appendLong(long var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Vector.Builder {
        public Builder appendLong(long var1);

        @Override
        public LongVector build();
    }
}

