/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.LongVectorBlock;

final class LongArrayVector
extends AbstractVector
implements LongVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongArrayVector.class) + RamUsageEstimator.shallowSizeOfInstance(LongVectorBlock.class);
    private final long[] values;

    LongArrayVector(long[] values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LongArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        long preAdjustedBytes = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)positions * 8L;
        blockFactory.adjustBreaker(preAdjustedBytes);
        boolean success = false;
        try {
            long[] values = new long[positions];
            for (int i = 0; i < positions; ++i) {
                values[i] = in.readLong();
            }
            LongArrayVector block = new LongArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(block.ramBytesUsed() - preAdjustedBytes);
            success = true;
            LongArrayVector longArrayVector = block;
            return longArrayVector;
        }
        finally {
            if (!success) {
                blockFactory.adjustBreaker(-preAdjustedBytes);
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeLong(this.values[i]);
        }
    }

    @Override
    public LongBlock asBlock() {
        return new LongVectorBlock(this);
    }

    @Override
    public long getLong(int position) {
        return this.values[position];
    }

    @Override
    public ElementType elementType() {
        return ElementType.LONG;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public LongVector filter(int ... positions) {
        try (LongVector.Builder builder = this.blockFactory().newLongVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendLong(this.values[pos]);
            }
            LongVector longVector = builder.build();
            return longVector;
        }
    }

    public static long ramBytesEstimated(long[] values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((long[])values);
    }

    public long ramBytesUsed() {
        return LongArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LongVector) {
            LongVector that = (LongVector)obj;
            return LongVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LongVector.hash(this);
    }

    public String toString() {
        String valuesString = IntStream.range(0, this.getPositionCount()).limit(10L).mapToObj(n -> String.valueOf(this.values[n])).collect(Collectors.joining(", ", "[", this.getPositionCount() > 10 ? ", ...]" : "]"));
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + valuesString + "]";
    }
}

