/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ConstantDoubleVector;
import org.elasticsearch.compute.data.DoubleArrayVector;
import org.elasticsearch.compute.data.DoubleVector;

final class DoubleVectorFixedBuilder
implements DoubleVector.FixedBuilder {
    private final BlockFactory blockFactory;
    private final double[] values;
    private final long preAdjustedBytes;
    private int nextIndex;

    DoubleVectorFixedBuilder(int size, BlockFactory blockFactory) {
        this.preAdjustedBytes = DoubleVectorFixedBuilder.ramBytesUsed(size);
        blockFactory.adjustBreaker(this.preAdjustedBytes);
        this.blockFactory = blockFactory;
        this.values = new double[size];
    }

    @Override
    public DoubleVectorFixedBuilder appendDouble(double value) {
        this.values[this.nextIndex++] = value;
        return this;
    }

    private static long ramBytesUsed(int size) {
        return size == 1 ? ConstantDoubleVector.RAM_BYTES_USED : DoubleArrayVector.BASE_RAM_BYTES_USED + RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)(size * 8)));
    }

    @Override
    public DoubleVector build() {
        if (this.nextIndex < 0) {
            throw new IllegalStateException("already closed");
        }
        if (this.nextIndex != this.values.length) {
            throw new IllegalStateException("expected to write [" + this.values.length + "] entries but wrote [" + this.nextIndex + "]");
        }
        this.nextIndex = -1;
        DoubleVector vector = this.values.length == 1 ? this.blockFactory.newConstantDoubleBlockWith(this.values[0], 1, this.preAdjustedBytes).asVector() : this.blockFactory.newDoubleArrayVector(this.values, this.values.length, this.preAdjustedBytes);
        assert (vector.ramBytesUsed() == this.preAdjustedBytes) : "fixed Builders should estimate the exact ram bytes used";
        return vector;
    }

    public void close() {
        if (this.nextIndex >= 0) {
            this.nextIndex = -1;
            this.blockFactory.adjustBreaker(-this.preAdjustedBytes);
        }
    }

    boolean isReleased() {
        return this.nextIndex < 0;
    }
}

