/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BooleanVectorBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Releasable;

public final class BooleanBigArrayVector
extends AbstractVector
implements BooleanVector,
Releasable {
    private static final long BASE_RAM_BYTES_USED = 0L;
    private final BitArray values;

    public BooleanBigArrayVector(BitArray values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BooleanBigArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        BitArray values = new BitArray(blockFactory.bigArrays(), true, in);
        boolean success = false;
        try {
            BooleanBigArrayVector vector = new BooleanBigArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(vector.ramBytesUsed() - RamUsageEstimator.sizeOf((Accountable)values));
            success = true;
            BooleanBigArrayVector booleanBigArrayVector = vector;
            return booleanBigArrayVector;
        }
        finally {
            if (!success) {
                values.close();
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        this.values.writeTo(out);
    }

    @Override
    public BooleanBlock asBlock() {
        return new BooleanVectorBlock(this);
    }

    @Override
    public boolean getBoolean(int position) {
        return this.values.get((long)position);
    }

    @Override
    public ElementType elementType() {
        return ElementType.BOOLEAN;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public long ramBytesUsed() {
        return 0L + RamUsageEstimator.sizeOf((Accountable)this.values);
    }

    @Override
    public BooleanVector filter(int ... positions) {
        BlockFactory blockFactory = this.blockFactory();
        BitArray filtered = new BitArray((long)positions.length, blockFactory.bigArrays());
        for (int i = 0; i < positions.length; ++i) {
            if (!this.values.get((long)positions[i])) continue;
            filtered.set((long)i);
        }
        return new BooleanBigArrayVector(filtered, positions.length, blockFactory);
    }

    @Override
    public void closeInternal() {
        this.values.close();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BooleanVector) {
            BooleanVector that = (BooleanVector)obj;
            return BooleanVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BooleanVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + this.values + "]";
    }
}

