/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.List;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;

public interface Block
extends Accountable,
BlockLoader.Block,
NamedWriteable,
RefCounted,
Releasable {
    public static final byte SERIALIZE_BLOCK_VALUES = 0;
    public static final byte SERIALIZE_BLOCK_VECTOR = 1;
    public static final byte SERIALIZE_BLOCK_ARRAY = 2;
    public static final byte SERIALIZE_BLOCK_BIG_ARRAY = 3;
    public static final byte SERIALIZE_BLOCK_ORDINAL = 3;

    public Vector asVector();

    public int getTotalValueCount();

    public int getPositionCount();

    public int getFirstValueIndex(int var1);

    public int getValueCount(int var1);

    public ElementType elementType();

    public BlockFactory blockFactory();

    public void allowPassingToDifferentDriver();

    public boolean isReleased();

    public boolean isNull(int var1);

    public int nullValuesCount();

    public boolean mayHaveNulls();

    public boolean areAllValuesNull();

    public boolean mayHaveMultivaluedFields();

    public Block filter(int ... var1);

    public MvOrdering mvOrdering();

    default public boolean mvDeduplicated() {
        return !this.mayHaveMultivaluedFields() || this.mvOrdering().deduplicated;
    }

    default public boolean mvSortedAscending() {
        return !this.mayHaveMultivaluedFields() || this.mvOrdering().sortedAscending;
    }

    public Block expand();

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(IntBlock.ENTRY, LongBlock.ENTRY, DoubleBlock.ENTRY, BytesRefBlock.ENTRY, BooleanBlock.ENTRY, ConstantNullBlock.ENTRY);
    }

    public static enum MvOrdering {
        UNORDERED(false, false),
        DEDUPLICATED_UNORDERD(true, false),
        DEDUPLICATED_AND_SORTED_ASCENDING(true, true);

        private final boolean deduplicated;
        private final boolean sortedAscending;

        private MvOrdering(boolean deduplicated, boolean sortedAscending) {
            this.deduplicated = deduplicated;
            this.sortedAscending = sortedAscending;
        }
    }

    public static interface Builder
    extends BlockLoader.Builder,
    Releasable {
        public Builder appendNull();

        public Builder beginPositionEntry();

        public Builder endPositionEntry();

        public Builder copyFrom(Block var1, int var2, int var3);

        public Builder mvOrdering(MvOrdering var1);

        public Block build();

        public static Block[] buildAll(Builder ... builders) {
            Releasable[] blocks = new Block[builders.length];
            try {
                for (int b = 0; b < blocks.length; ++b) {
                    blocks[b] = builders[b].build();
                }
            }
            finally {
                if (blocks[blocks.length - 1] == null) {
                    Releasables.closeExpectNoException((Releasable[])blocks);
                }
            }
            return blocks;
        }
    }
}

