/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.LongLongBlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.BatchEncoder;
import org.elasticsearch.compute.operator.HashAggregationOperator;
import org.elasticsearch.compute.operator.MultivalueDedupe;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class PackedValuesBlockHash
extends BlockHash {
    static final int DEFAULT_BATCH_SIZE = Math.toIntExact(ByteSizeValue.ofKb((long)10L).getBytes());
    private final int emitBatchSize;
    private final BytesRefHash bytesRefHash;
    private final int nullTrackingBytes;
    private final BytesRefBuilder bytes = new BytesRefBuilder();
    private final Group[] groups;

    PackedValuesBlockHash(List<HashAggregationOperator.GroupSpec> specs, BlockFactory blockFactory, int emitBatchSize) {
        super(blockFactory);
        this.groups = (Group[])specs.stream().map(Group::new).toArray(Group[]::new);
        this.emitBatchSize = emitBatchSize;
        this.bytesRefHash = new BytesRefHash(1L, blockFactory.bigArrays());
        this.nullTrackingBytes = (this.groups.length + 7) / 8;
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        this.add(page, addInput, DEFAULT_BATCH_SIZE);
    }

    void add(Page page, GroupingAggregatorFunction.AddInput addInput, int batchSize) {
        try (AddWork work = new AddWork(page, addInput, batchSize);){
            work.add();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block[] getKeys() {
        int size = Math.toIntExact(this.bytesRefHash.size());
        BatchEncoder.Decoder[] decoders = new BatchEncoder.Decoder[this.groups.length];
        Releasable[] builders = new Block.Builder[this.groups.length];
        try {
            int offset;
            for (int g = 0; g < builders.length; ++g) {
                ElementType elementType = this.groups[g].spec.elementType();
                decoders[g] = BatchEncoder.decoder(elementType);
                builders[g] = elementType.newBlockBuilder(size, this.blockFactory);
            }
            BytesRef[] values = new BytesRef[(int)Math.min(100L, this.bytesRefHash.size())];
            BytesRef[] nulls = new BytesRef[values.length];
            for (offset = 0; offset < values.length; ++offset) {
                values[offset] = new BytesRef();
                nulls[offset] = new BytesRef();
                nulls[offset].length = this.nullTrackingBytes;
            }
            offset = 0;
            int i = 0;
            while ((long)i < this.bytesRefHash.size()) {
                values[offset] = this.bytesRefHash.get((long)i, values[offset]);
                nulls[offset].bytes = values[offset].bytes;
                nulls[offset].offset = values[offset].offset;
                values[offset].offset += this.nullTrackingBytes;
                values[offset].length -= this.nullTrackingBytes;
                if (++offset == values.length) {
                    this.readKeys(decoders, (Block.Builder[])builders, nulls, values, offset);
                    offset = 0;
                }
                ++i;
            }
            if (offset > 0) {
                this.readKeys(decoders, (Block.Builder[])builders, nulls, values, offset);
            }
            Releasable[] keyBlocks = new Block[this.groups.length];
            try {
                for (int g = 0; g < keyBlocks.length; ++g) {
                    keyBlocks[g] = builders[g].build();
                }
            }
            finally {
                if (keyBlocks[keyBlocks.length - 1] == null) {
                    Releasables.closeExpectNoException((Releasable[])keyBlocks);
                }
            }
            Releasable[] releasableArray = keyBlocks;
            return releasableArray;
        }
        finally {
            Releasables.closeExpectNoException((Releasable[])builders);
        }
    }

    private void readKeys(BatchEncoder.Decoder[] decoders, Block.Builder[] builders, BytesRef[] nulls, BytesRef[] values, int count) {
        for (int g = 0; g < builders.length; ++g) {
            int nullByte = g / 8;
            int nullShift = g % 8;
            byte nullTest = (byte)(1 << nullShift);
            BatchEncoder.IsNull isNull = offset -> {
                BytesRef n = nulls[offset];
                return (n.bytes[n.offset + nullByte] & nullTest) != 0;
            };
            decoders[g].decode(builders[g], isNull, values, count);
        }
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(0, Math.toIntExact(this.bytesRefHash.size()), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(0, Math.toIntExact(this.bytesRefHash.size())).seenGroupIds(bigArrays);
    }

    public void close() {
        this.bytesRefHash.close();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PackedValuesBlockHash{groups=[");
        boolean first = true;
        for (int i = 0; i < this.groups.length; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            Group group = this.groups[i];
            b.append(group.spec.channel()).append(':').append((Object)group.spec.elementType());
        }
        b.append("], entries=").append(this.bytesRefHash.size());
        b.append(", size=").append(ByteSizeValue.ofBytes((long)this.bytesRefHash.ramBytesUsed()));
        return b.append("}").toString();
    }

    private static class Group {
        final HashAggregationOperator.GroupSpec spec;
        BatchEncoder encoder;
        int positionOffset;
        int valueOffset;
        int loopedIndex;
        int valueCount;
        int bytesStart;

        Group(HashAggregationOperator.GroupSpec spec) {
            this.spec = spec;
        }
    }

    class AddWork
    extends LongLongBlockHash.AbstractAddBlock {
        final int positionCount;
        int position;

        AddWork(Page page, GroupingAggregatorFunction.AddInput addInput, int batchSize) {
            super(PackedValuesBlockHash.this.blockFactory, PackedValuesBlockHash.this.emitBatchSize, addInput);
            for (Group group : PackedValuesBlockHash.this.groups) {
                group.encoder = MultivalueDedupe.batchEncoder(page.getBlock(group.spec.channel()), batchSize, true);
            }
            PackedValuesBlockHash.this.bytes.grow(PackedValuesBlockHash.this.nullTrackingBytes);
            this.positionCount = page.getPositionCount();
        }

        void add() {
            this.position = 0;
            while (this.position < this.positionCount) {
                boolean singleEntry = true;
                for (Group g : PackedValuesBlockHash.this.groups) {
                    BatchEncoder encoder = g.encoder;
                    ++g.positionOffset;
                    while (g.positionOffset >= encoder.positionCount()) {
                        encoder.encodeNextBatch();
                        g.positionOffset = 0;
                        g.valueOffset = 0;
                    }
                    g.valueCount = encoder.valueCount(g.positionOffset);
                    singleEntry &= g.valueCount == 1;
                }
                Arrays.fill(PackedValuesBlockHash.this.bytes.bytes(), 0, PackedValuesBlockHash.this.nullTrackingBytes, (byte)0);
                PackedValuesBlockHash.this.bytes.setLength(PackedValuesBlockHash.this.nullTrackingBytes);
                if (singleEntry) {
                    this.addSingleEntry();
                } else {
                    this.addMultipleEntries();
                }
                ++this.position;
            }
            this.emitOrds();
        }

        private void addSingleEntry() {
            for (int g = 0; g < PackedValuesBlockHash.this.groups.length; ++g) {
                Group group = PackedValuesBlockHash.this.groups[g];
                if (group.encoder.read(group.valueOffset++, PackedValuesBlockHash.this.bytes) != 0) continue;
                int nullByte = g / 8;
                int nullShift = g % 8;
                byte[] byArray = PackedValuesBlockHash.this.bytes.bytes();
                int n = nullByte;
                byArray[n] = (byte)(byArray[n] | (byte)(1 << nullShift));
            }
            int ord = Math.toIntExact(BlockHash.hashOrdToGroup(PackedValuesBlockHash.this.bytesRefHash.add(PackedValuesBlockHash.this.bytes.get())));
            this.ords.appendInt(ord);
            this.addedValue(this.position);
        }

        /*
         * Unable to fully structure code
         */
        private void addMultipleEntries() {
            this.ords.beginPositionEntry();
            g = 0;
            block0: while (true) {
                if (g < PackedValuesBlockHash.this.groups.length) {
                    group = PackedValuesBlockHash.this.groups[g];
                    group.bytesStart = PackedValuesBlockHash.this.bytes.length();
                    if (group.encoder.read(group.valueOffset + group.loopedIndex, PackedValuesBlockHash.this.bytes) == 0) {
                        if (!AddWork.$assertionsDisabled && group.valueCount != 1) {
                            throw new AssertionError((Object)"null value in non-singleton list");
                        }
                        nullByte = g / 8;
                        nullShift = g % 8;
                        v0 = PackedValuesBlockHash.this.bytes.bytes();
                        v1 = nullByte;
                        v0[v1] = (byte)(v0[v1] | (byte)(1 << nullShift));
                    }
                    ++group.loopedIndex;
                    ++g;
                    continue;
                }
                ord = Math.toIntExact(BlockHash.hashOrdToGroup(PackedValuesBlockHash.this.bytesRefHash.add(PackedValuesBlockHash.this.bytes.get())));
                this.ords.appendInt(ord);
                this.addedValueInMultivaluePosition(this.position);
                group = PackedValuesBlockHash.this.groups[--g];
                PackedValuesBlockHash.this.bytes.setLength(group.bytesStart);
                while (true) {
                    if (group.loopedIndex == group.valueCount) ** break;
                    continue block0;
                    group.loopedIndex = 0;
                    if (g == 0) break block0;
                    group = PackedValuesBlockHash.this.groups[--g];
                    PackedValuesBlockHash.this.bytes.setLength(group.bytesStart);
                }
                break;
            }
            this.ords.endPositionEntry();
            for (Group group : PackedValuesBlockHash.this.groups) {
                group.valueOffset += group.valueCount;
            }
        }
    }
}

