/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class LongLongBlockHash
extends BlockHash {
    private final int channel1;
    private final int channel2;
    private final int emitBatchSize;
    private final LongLongHash hash;
    private static final long[] EMPTY = new long[0];

    LongLongBlockHash(BlockFactory blockFactory, int channel1, int channel2, int emitBatchSize) {
        super(blockFactory);
        this.channel1 = channel1;
        this.channel2 = channel2;
        this.emitBatchSize = emitBatchSize;
        this.hash = new LongLongHash(1L, blockFactory.bigArrays());
    }

    public void close() {
        Releasables.close((Releasable)this.hash);
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        LongBlock block1 = (LongBlock)page.getBlock(this.channel1);
        LongBlock block2 = (LongBlock)page.getBlock(this.channel2);
        LongVector vector1 = block1.asVector();
        LongVector vector2 = block2.asVector();
        if (vector1 != null && vector2 != null) {
            try (IntBlock groupIds = this.add(vector1, vector2).asBlock();){
                addInput.add(0, groupIds.asVector());
            }
        }
        try (AddBlock addBlock = new AddBlock(block1, block2, addInput);){
            addBlock.add();
        }
    }

    private IntVector add(LongVector vector1, LongVector vector2) {
        int positions = vector1.getPositionCount();
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendInt(Math.toIntExact(LongLongBlockHash.hashOrdToGroup(this.hash.add(vector1.getLong(i), vector2.getLong(i)))));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    static int add(long[] seen, int nextSeen, long v) {
        for (int c = 0; c < nextSeen; ++c) {
            if (seen[c] != v) continue;
            return nextSeen;
        }
        seen[nextSeen] = v;
        return nextSeen + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block[] getKeys() {
        int positions = (int)this.hash.size();
        LongVector k1 = null;
        LongVector k2 = null;
        try {
            try (LongVector.Builder keys1 = this.blockFactory.newLongVectorBuilder(positions);
                 LongVector.Builder keys2 = this.blockFactory.newLongVectorBuilder(positions);){
                for (long i = 0L; i < (long)positions; ++i) {
                    keys1.appendLong(this.hash.getKey1(i));
                    keys2.appendLong(this.hash.getKey2(i));
                }
                k1 = keys1.build();
                k2 = keys2.build();
            }
            if (k2 != null) return new Block[]{k1.asBlock(), k2.asBlock()};
        }
        catch (Throwable throwable) {
            if (k2 != null) throw throwable;
            Releasables.close(k1);
            throw throwable;
        }
        Releasables.close((Releasable)k1);
        return new Block[]{k1.asBlock(), k2.asBlock()};
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(0, Math.toIntExact(this.hash.size()), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(0, Math.toIntExact(this.hash.size())).seenGroupIds(bigArrays);
    }

    public String toString() {
        return "LongLongBlockHash{channels=[" + this.channel1 + "," + this.channel2 + "], entries=" + this.hash.size() + "}";
    }

    private class AddBlock
    extends AbstractAddBlock {
        private final LongBlock block1;
        private final LongBlock block2;

        AddBlock(LongBlock block1, LongBlock block2, GroupingAggregatorFunction.AddInput addInput) {
            super(LongLongBlockHash.this.blockFactory, LongLongBlockHash.this.emitBatchSize, addInput);
            this.block1 = block1;
            this.block2 = block2;
        }

        void add() {
            int positions = this.block1.getPositionCount();
            long[] seen1 = EMPTY;
            long[] seen2 = EMPTY;
            for (int p = 0; p < positions; ++p) {
                if (this.block1.isNull(p) || this.block2.isNull(p)) {
                    this.ords.appendNull();
                    this.addedValue(p);
                    continue;
                }
                int start1 = this.block1.getFirstValueIndex(p);
                int start2 = this.block2.getFirstValueIndex(p);
                int count1 = this.block1.getValueCount(p);
                int count2 = this.block2.getValueCount(p);
                if (count1 == 1 && count2 == 1) {
                    this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(LongLongBlockHash.this.hash.add(this.block1.getLong(start1), this.block2.getLong(start2)))));
                    this.addedValue(p);
                    continue;
                }
                int end = start1 + count1;
                if (seen1.length < count1) {
                    seen1 = new long[ArrayUtil.oversize((int)count1, (int)8)];
                }
                int seenSize1 = 0;
                for (int i = start1; i < end; ++i) {
                    seenSize1 = LongLongBlockHash.add(seen1, seenSize1, this.block1.getLong(i));
                }
                if (seen2.length < count2) {
                    seen2 = new long[ArrayUtil.oversize((int)count2, (int)8)];
                }
                int seenSize2 = 0;
                end = start2 + count2;
                for (int i = start2; i < end; ++i) {
                    seenSize2 = LongLongBlockHash.add(seen2, seenSize2, this.block2.getLong(i));
                }
                if (seenSize1 == 1 && seenSize2 == 1) {
                    this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(LongLongBlockHash.this.hash.add(seen1[0], seen2[0]))));
                    this.addedValue(p);
                    continue;
                }
                this.ords.beginPositionEntry();
                for (int s1 = 0; s1 < seenSize1; ++s1) {
                    for (int s2 = 0; s2 < seenSize2; ++s2) {
                        this.ords.appendInt(Math.toIntExact(BlockHash.hashOrdToGroup(LongLongBlockHash.this.hash.add(seen1[s1], seen2[s2]))));
                        this.addedValueInMultivaluePosition(p);
                    }
                }
                this.ords.endPositionEntry();
            }
            this.emitOrds();
        }
    }

    static class AbstractAddBlock
    implements Releasable {
        private final BlockFactory blockFactory;
        private final int emitBatchSize;
        private final GroupingAggregatorFunction.AddInput addInput;
        private int positionOffset = 0;
        private int added = 0;
        protected IntBlock.Builder ords;

        AbstractAddBlock(BlockFactory blockFactory, int emitBatchSize, GroupingAggregatorFunction.AddInput addInput) {
            this.blockFactory = blockFactory;
            this.emitBatchSize = emitBatchSize;
            this.addInput = addInput;
            this.ords = blockFactory.newIntBlockBuilder(emitBatchSize);
        }

        protected final void addedValue(int position) {
            if (++this.added % this.emitBatchSize == 0) {
                this.rollover(position + 1);
            }
        }

        protected final void addedValueInMultivaluePosition(int position) {
            if (++this.added % this.emitBatchSize == 0) {
                this.ords.endPositionEntry();
                this.rollover(position);
                this.ords.beginPositionEntry();
            }
        }

        protected final void emitOrds() {
            try (IntBlock ordsBlock = this.ords.build();){
                this.addInput.add(this.positionOffset, ordsBlock);
            }
        }

        private void rollover(int position) {
            this.emitOrds();
            this.positionOffset = position;
            this.ords = this.blockFactory.newIntBlockBuilder(this.emitBatchSize);
        }

        public final void close() {
            this.ords.close();
        }
    }
}

