/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.util.BitSet;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.MultivalueDedupe;
import org.elasticsearch.compute.operator.MultivalueDedupeInt;

final class IntBlockHash
extends BlockHash {
    private final int channel;
    private final LongHash longHash;
    private boolean seenNull;

    IntBlockHash(int channel, BlockFactory blockFactory) {
        super(blockFactory);
        this.channel = channel;
        this.longHash = new LongHash(1L, blockFactory.bigArrays());
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        Object block = page.getBlock(this.channel);
        if (block.areAllValuesNull()) {
            this.seenNull = true;
            try (IntVector groupIds = this.blockFactory.newConstantIntVector(0, block.getPositionCount());){
                addInput.add(0, groupIds);
            }
        }
        IntBlock intBlock = (IntBlock)block;
        IntVector intVector = intBlock.asVector();
        if (intVector == null) {
            try (IntBlock groupIds = this.add(intBlock);){
                addInput.add(0, groupIds);
            }
        }
        try (IntVector groupIds = this.add(intVector);){
            addInput.add(0, groupIds);
        }
    }

    private IntVector add(IntVector vector) {
        int positions = vector.getPositionCount();
        try (IntVector.FixedBuilder builder = this.blockFactory.newIntVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendInt(Math.toIntExact(IntBlockHash.hashOrdToGroupNullReserved(this.longHash.add((long)vector.getInt(i)))));
            }
            IntVector intVector = builder.build();
            return intVector;
        }
    }

    private IntBlock add(IntBlock block) {
        MultivalueDedupe.HashResult result = new MultivalueDedupeInt(block).hash(this.blockFactory, this.longHash);
        this.seenNull |= result.sawNull();
        return result.ords();
    }

    public IntBlock[] getKeys() {
        if (this.seenNull) {
            int size = Math.toIntExact(this.longHash.size() + 1L);
            int[] keys = new int[size];
            for (int i = 1; i < size; ++i) {
                keys[i] = (int)this.longHash.get((long)(i - 1));
            }
            BitSet nulls = new BitSet(1);
            nulls.set(0);
            return new IntBlock[]{this.blockFactory.newIntArrayBlock(keys, keys.length, null, nulls, Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING)};
        }
        int size = Math.toIntExact(this.longHash.size());
        int[] keys = new int[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = (int)this.longHash.get((long)i);
        }
        return new IntBlock[]{this.blockFactory.newIntArrayVector(keys, keys.length).asBlock()};
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(this.seenNull ? 0 : 1, Math.toIntExact(this.longHash.size() + 1L), this.blockFactory);
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(this.seenNull ? 0 : 1, Math.toIntExact(this.longHash.size() + 1L)).seenGroupIds(bigArrays);
    }

    public void close() {
        this.longHash.close();
    }

    public String toString() {
        return "IntBlockHash{channel=" + this.channel + ", entries=" + this.longHash.size() + ", seenNull=" + this.seenNull + "}";
    }
}

