/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;

class ValuesDoubleAggregator {
    ValuesDoubleAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, double v) {
        state.values.add(Double.doubleToLongBits(v));
    }

    public static void combineIntermediate(SingleState state, DoubleBlock values) {
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesDoubleAggregator.combine(state, values.getDouble(i));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(BigArrays bigArrays) {
        return new GroupingState(bigArrays);
    }

    public static void combine(GroupingState state, int groupId, double v) {
        state.values.add((long)groupId, Double.doubleToLongBits(v));
    }

    public static void combineIntermediate(GroupingState state, int groupId, DoubleBlock values, int valuesPosition) {
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            ValuesDoubleAggregator.combine(state, groupId, values.getDouble(i));
        }
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState state, int statePosition) {
        int id = 0;
        while ((long)id < state.values.size()) {
            if (state.values.getKey1((long)id) == (long)statePosition) {
                double value = Double.longBitsToDouble(state.values.getKey2((long)id));
                ValuesDoubleAggregator.combine(current, currentGroupId, value);
            }
            ++id;
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory(), selected);
    }

    public static class SingleState
    implements Releasable {
        private final LongHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new LongHash(1L, bigArrays);
        }

        void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            if (this.values.size() == 1L) {
                return blockFactory.newConstantDoubleBlockWith(Double.longBitsToDouble(this.values.get(0L)), 1);
            }
            try (DoubleBlock.Builder builder = blockFactory.newDoubleBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendDouble(Double.longBitsToDouble(this.values.get((long)id)));
                    ++id;
                }
                builder.endPositionEntry();
                DoubleBlock doubleBlock = builder.build();
                return doubleBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements Releasable {
        private final LongLongHash values;

        private GroupingState(BigArrays bigArrays) {
            this.values = new LongLongHash(1L, bigArrays);
        }

        void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(selected.getPositionCount());
            }
            try (DoubleBlock.Builder builder = blockFactory.newDoubleBlockBuilder(selected.getPositionCount());){
                block13: for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int selectedGroup = selected.getInt(s);
                    int count = 0;
                    double first = 0.0;
                    int id = 0;
                    while ((long)id < this.values.size()) {
                        if (this.values.getKey1((long)id) == (long)selectedGroup) {
                            double value = Double.longBitsToDouble(this.values.getKey2((long)id));
                            switch (count) {
                                case 0: {
                                    first = value;
                                    break;
                                }
                                case 1: {
                                    builder.beginPositionEntry();
                                    builder.appendDouble(first);
                                    builder.appendDouble(value);
                                    break;
                                }
                                default: {
                                    builder.appendDouble(value);
                                }
                            }
                            ++count;
                        }
                        ++id;
                    }
                    switch (count) {
                        case 0: {
                            builder.appendNull();
                            continue block13;
                        }
                        case 1: {
                            builder.appendDouble(first);
                            continue block13;
                        }
                        default: {
                            builder.endPositionEntry();
                        }
                    }
                }
                DoubleBlock doubleBlock = builder.build();
                return doubleBlock;
            }
        }

        void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            this.values.close();
        }
    }
}

