/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.search.aggregations.metrics.InternalMedianAbsoluteDeviation;
import org.elasticsearch.search.aggregations.metrics.TDigestState;

public final class QuantileStates {
    public static final double MEDIAN = 50.0;
    static final double DEFAULT_COMPRESSION = 1000.0;

    private QuantileStates() {
    }

    private static Double percentileParam(double p) {
        return 0.0 <= p && p <= 100.0 ? Double.valueOf(p) : null;
    }

    static BytesRef serializeDigest(TDigestState digest) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamStreamOutput out = new OutputStreamStreamOutput((OutputStream)baos);
        try {
            TDigestState.write((TDigestState)digest, (StreamOutput)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new BytesRef(baos.toByteArray());
    }

    static TDigestState deserializeDigest(BytesRef bytesRef) {
        ByteArrayStreamInput in = new ByteArrayStreamInput(bytesRef.bytes);
        in.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        try {
            return TDigestState.read((StreamInput)in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class GroupingState
    implements GroupingAggregatorState {
        private long largestGroupId = -1L;
        private ObjectArray<TDigestState> digests;
        private final BigArrays bigArrays;
        private final Double percentile;

        GroupingState(BigArrays bigArrays, double percentile) {
            this.bigArrays = bigArrays;
            this.digests = bigArrays.newObjectArray(1L);
            this.percentile = QuantileStates.percentileParam(percentile);
        }

        private TDigestState getOrAddGroup(int groupId) {
            this.digests = this.bigArrays.grow(this.digests, (long)(groupId + 1));
            TDigestState qs = (TDigestState)this.digests.get((long)groupId);
            if (qs == null) {
                qs = TDigestState.create((double)1000.0);
                this.digests.set((long)groupId, (Object)qs);
            }
            return qs;
        }

        void add(int groupId, double v) {
            this.getOrAddGroup(groupId).add(v);
        }

        void add(int groupId, TDigestState other) {
            if (other != null) {
                this.getOrAddGroup(groupId).add(other);
            }
        }

        void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        }

        void add(int groupId, BytesRef other) {
            this.getOrAddGroup(groupId).add(QuantileStates.deserializeDigest(other));
        }

        TDigestState getOrNull(int position) {
            if ((long)position < this.digests.size()) {
                return (TDigestState)this.digests.get((long)position);
            }
            return null;
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 1);
            try (BytesRefBlock.Builder builder = driverContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    TDigestState state;
                    int group = selected.getInt(i);
                    if ((long)group < this.digests.size()) {
                        state = this.getOrNull(group);
                        if (state == null) {
                            state = TDigestState.create((double)1000.0);
                        }
                    } else {
                        state = TDigestState.create((double)1000.0);
                    }
                    builder.appendBytesRef(QuantileStates.serializeDigest(state));
                }
                blocks[offset] = builder.build();
            }
        }

        Block evaluateMedianAbsoluteDeviation(IntVector selected, DriverContext driverContext) {
            assert (this.percentile == 50.0) : "Median must be 50th percentile [percentile = " + this.percentile + "]";
            try (DoubleBlock.Builder builder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int si = selected.getInt(i);
                    if ((long)si >= this.digests.size()) {
                        builder.appendNull();
                        continue;
                    }
                    TDigestState digest = (TDigestState)this.digests.get((long)si);
                    if (digest != null && digest.size() > 0L) {
                        builder.appendDouble(InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation((TDigestState)digest));
                        continue;
                    }
                    builder.appendNull();
                }
                DoubleBlock doubleBlock = builder.build();
                return doubleBlock;
            }
        }

        Block evaluatePercentile(IntVector selected, DriverContext driverContext) {
            try (DoubleBlock.Builder builder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int si = selected.getInt(i);
                    if ((long)si >= this.digests.size()) {
                        builder.appendNull();
                        continue;
                    }
                    TDigestState digest = (TDigestState)this.digests.get((long)si);
                    if (this.percentile != null && digest != null && digest.size() > 0L) {
                        builder.appendDouble(digest.quantile(this.percentile / 100.0));
                        continue;
                    }
                    builder.appendNull();
                }
                DoubleBlock doubleBlock = builder.build();
                return doubleBlock;
            }
        }

        public void close() {
            this.digests.close();
        }
    }

    static class SingleState
    implements AggregatorState {
        private TDigestState digest = TDigestState.create((double)1000.0);
        private final Double percentile;

        SingleState(double percentile) {
            this.percentile = QuantileStates.percentileParam(percentile);
        }

        public void close() {
        }

        void add(double v) {
            this.digest.add(v);
        }

        void add(BytesRef other) {
            this.digest.add(QuantileStates.deserializeDigest(other));
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            assert (blocks.length >= offset + 1);
            blocks[offset] = driverContext.blockFactory().newConstantBytesRefBlockWith(QuantileStates.serializeDigest(this.digest), 1);
        }

        Block evaluateMedianAbsoluteDeviation(DriverContext driverContext) {
            BlockFactory blockFactory = driverContext.blockFactory();
            assert (this.percentile == 50.0) : "Median must be 50th percentile [percentile = " + this.percentile + "]";
            if (this.digest.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            double result = InternalMedianAbsoluteDeviation.computeMedianAbsoluteDeviation((TDigestState)this.digest);
            return blockFactory.newConstantDoubleBlockWith(result, 1);
        }

        Block evaluatePercentile(DriverContext driverContext) {
            BlockFactory blockFactory = driverContext.blockFactory();
            if (this.percentile == null || this.digest.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            double result = this.digest.quantile(this.percentile / 100.0);
            return blockFactory.newConstantDoubleBlockWith(result, 1);
        }
    }
}

