/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.action;

import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.fleet.action.GetSecretRequest;
import org.elasticsearch.xpack.fleet.action.GetSecretResponse;

public class TransportGetSecretAction
extends HandledTransportAction<GetSecretRequest, GetSecretResponse> {
    private final Client client;

    @Inject
    public TransportGetSecretAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/fleet/secrets/get", transportService, actionFilters, GetSecretRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = new OriginSettingClient(client, "fleet");
    }

    protected void doExecute(Task task, GetSecretRequest request, ActionListener<GetSecretResponse> listener) {
        this.client.prepareGet(".fleet-secrets", request.id()).execute(listener.delegateFailureAndWrap((delegate, getResponse) -> {
            if (getResponse.isSourceEmpty()) {
                delegate.onFailure((Exception)new ResourceNotFoundException("No secret with id [" + request.id() + "]", new Object[0]));
                return;
            }
            delegate.onResponse((Object)new GetSecretResponse(getResponse.getId(), getResponse.getSource().get("value").toString()));
        }));
    }
}

