/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.action;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.GlobalCheckpointListeners;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class GetGlobalCheckpointsShardAction
extends ActionType<Response> {
    public static final GetGlobalCheckpointsShardAction INSTANCE = new GetGlobalCheckpointsShardAction();
    public static final String NAME = "indices:monitor/fleet/global_checkpoints[s]";

    private GetGlobalCheckpointsShardAction() {
        super(NAME);
    }

    public static class TransportAction
    extends TransportSingleShardAction<Request, Response> {
        private final IndicesService indicesService;

        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
            super(GetGlobalCheckpointsShardAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, (Executor)threadPool.executor("generic"));
            this.indicesService = indicesService;
        }

        protected Response shardOperation(Request request, ShardId shardId) {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            IndexShard indexShard = indexService.getShard(shardId.id());
            SeqNoStats seqNoStats = indexShard.seqNoStats();
            return new Response(seqNoStats.getGlobalCheckpoint(), false);
        }

        protected void asyncShardOperation(final Request request, final ShardId shardId, final ActionListener<Response> listener) throws IOException {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            final IndexShard indexShard = indexService.getShard(shardId.id());
            SeqNoStats seqNoStats = indexShard.seqNoStats();
            if (request.waitForAdvance() && request.checkpoint() >= seqNoStats.getGlobalCheckpoint()) {
                indexShard.addGlobalCheckpointListener(request.checkpoint() + 1L, new GlobalCheckpointListeners.GlobalCheckpointListener(){

                    public Executor executor() {
                        return threadPool.executor("generic");
                    }

                    public void accept(long g, Exception e) {
                        if (g != -2L) {
                            assert (request.checkpoint() < g) : shardId + " only advanced to [" + g + "] while waiting for [" + request.checkpoint() + "]";
                            this.globalCheckpointAdvanced(shardId, request, (ActionListener<Response>)listener);
                        } else {
                            assert (e != null);
                            TransportAction.globalCheckpointAdvancementFailure(indexShard, request, e, (ActionListener<Response>)listener);
                        }
                    }
                }, request.timeout());
            } else {
                super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
            }
        }

        private void globalCheckpointAdvanced(ShardId shardId, Request request, ActionListener<Response> listener) {
            try {
                super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
            }
            catch (IOException caught) {
                listener.onFailure((Exception)caught);
            }
        }

        private static void globalCheckpointAdvancementFailure(IndexShard indexShard, Request request, Exception e, ActionListener<Response> listener) {
            try {
                if (e instanceof TimeoutException) {
                    long globalCheckpoint = indexShard.seqNoStats().getGlobalCheckpoint();
                    if (request.checkpoint() >= globalCheckpoint) {
                        listener.onResponse((Object)new Response(globalCheckpoint, true));
                    } else {
                        listener.onResponse((Object)new Response(globalCheckpoint, false));
                    }
                } else {
                    listener.onFailure(e);
                }
            }
            catch (RuntimeException e2) {
                listener.onFailure((Exception)e2);
            }
        }

        protected Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        protected boolean resolveIndex(Request request) {
            return true;
        }

        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            return state.routingTable().shardRoutingTable(((Request)request.request()).getShardId()).primaryShardIt();
        }
    }

    public static class Request
    extends SingleShardRequest<Request> {
        private final ShardId shardId;
        private final boolean waitForAdvance;
        private final long checkpoint;
        private final TimeValue timeout;

        Request(ShardId shardId, boolean waitForAdvance, long checkpoint, TimeValue timeout) {
            super(shardId.getIndexName());
            this.shardId = shardId;
            this.waitForAdvance = waitForAdvance;
            this.checkpoint = checkpoint;
            this.timeout = timeout;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.waitForAdvance = in.readBoolean();
            this.checkpoint = in.readLong();
            this.timeout = in.readTimeValue();
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        public TimeValue timeout() {
            return this.timeout;
        }

        public boolean waitForAdvance() {
            return this.waitForAdvance;
        }

        public long checkpoint() {
            return this.checkpoint;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeBoolean(this.waitForAdvance);
            out.writeLong(this.checkpoint);
            out.writeTimeValue(this.timeout);
        }
    }

    public static class Response
    extends ActionResponse {
        private final long globalCheckpoint;
        private final boolean timedOut;

        public Response(long globalCheckpoint, boolean timedOut) {
            this.globalCheckpoint = globalCheckpoint;
            this.timedOut = timedOut;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.globalCheckpoint = in.readLong();
            this.timedOut = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.globalCheckpoint);
            out.writeBoolean(this.timedOut);
        }

        public long getGlobalCheckpoint() {
            return this.globalCheckpoint;
        }

        public boolean timedOut() {
            return this.timedOut;
        }
    }
}

