/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeliverSingleUseTokenExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DeliverSingleUseTokenExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String DELIVER_SINGLE_USE_TOKEN_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.49";
    private static final byte VALIDITY_DURATION_MILLIS_BER_TYPE = -128;
    private static final byte MESSAGE_SUBJECT_BER_TYPE = -127;
    private static final byte FULL_TEXT_BEFORE_TOKEN_BER_TYPE = -126;
    private static final byte FULL_TEXT_AFTER_TOKEN_BER_TYPE = -125;
    private static final byte COMPACT_TEXT_BEFORE_TOKEN_BER_TYPE = -124;
    private static final byte COMPACT_TEXT_AFTER_TOKEN_BER_TYPE = -123;
    private static final byte PREFERRED_DELIVERY_MECHANISM_BER_TYPE = -90;
    private static final byte DELIVER_IF_PASSWORD_EXPIRED_TYPE = -121;
    private static final byte DELIVER_IF_ACCOUNT_LOCKED_TYPE = -120;
    private static final byte DELIVER_IF_ACCOUNT_DISABLED_TYPE = -119;
    private static final byte DELIVER_IF_ACCOUNT_EXPIRED_TYPE = -118;
    private static final long serialVersionUID = -4158226639899928825L;
    private final boolean deliverIfAccountDisabled;
    private final boolean deliverIfAccountExpired;
    private final boolean deliverIfAccountLocked;
    private final boolean deliverIfPasswordExpired;
    @NotNull
    private final List<ObjectPair<String, String>> preferredDeliveryMechanisms;
    @Nullable
    private final Long validityDurationMillis;
    @Nullable
    private final String compactTextAfterToken;
    @Nullable
    private final String compactTextBeforeToken;
    @Nullable
    private final String fullTextAfterToken;
    @Nullable
    private final String fullTextBeforeToken;
    @Nullable
    private final String messageSubject;
    @NotNull
    private final String tokenID;
    @NotNull
    private final String userDN;

    public DeliverSingleUseTokenExtendedRequest(@NotNull String userDN, @NotNull String tokenID, @Nullable Long validityDurationMillis, @Nullable String messageSubject, @Nullable String fullTextBeforeToken, @Nullable String fullTextAfterToken, @Nullable String compactTextBeforeToken, @Nullable String compactTextAfterToken, @Nullable List<ObjectPair<String, String>> preferredDeliveryMechanisms, boolean deliverIfPasswordExpired, boolean deliverIfAccountLocked, boolean deliverIfAccountDisabled, boolean deliverIfAccountExpired, Control ... controls) {
        super(DELIVER_SINGLE_USE_TOKEN_REQUEST_OID, DeliverSingleUseTokenExtendedRequest.encodeValue(userDN, tokenID, validityDurationMillis, messageSubject, fullTextBeforeToken, fullTextAfterToken, compactTextBeforeToken, compactTextAfterToken, preferredDeliveryMechanisms, deliverIfPasswordExpired, deliverIfAccountLocked, deliverIfAccountDisabled, deliverIfAccountExpired), controls);
        this.userDN = userDN;
        this.tokenID = tokenID;
        this.validityDurationMillis = validityDurationMillis;
        this.messageSubject = messageSubject;
        this.fullTextBeforeToken = fullTextBeforeToken;
        this.fullTextAfterToken = fullTextAfterToken;
        this.compactTextBeforeToken = compactTextBeforeToken;
        this.compactTextAfterToken = compactTextAfterToken;
        this.deliverIfPasswordExpired = deliverIfPasswordExpired;
        this.deliverIfAccountLocked = deliverIfAccountLocked;
        this.deliverIfAccountDisabled = deliverIfAccountDisabled;
        this.deliverIfAccountExpired = deliverIfAccountExpired;
        this.preferredDeliveryMechanisms = preferredDeliveryMechanisms == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ObjectPair<String, String>>(preferredDeliveryMechanisms));
    }

    public DeliverSingleUseTokenExtendedRequest(@NotNull ExtendedRequest request) throws LDAPException {
        super(request);
        ASN1OctetString value = request.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_SINGLE_USE_TOKEN_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.userDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            this.tokenID = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
            Long validityDuration = null;
            String subject = null;
            String fullBefore = null;
            String fullAfter = null;
            String compactBefore = null;
            String compactAfter = null;
            ArrayList<ObjectPair<String, String>> pdmList = new ArrayList<ObjectPair<String, String>>(10);
            boolean ifPasswordExpired = false;
            boolean ifAccountLocked = false;
            boolean ifAccountDisabled = false;
            boolean ifAccountExpired = false;
            block16: for (int i = 2; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -128: {
                        validityDuration = ASN1Long.decodeAsLong(elements[i]).longValue();
                        continue block16;
                    }
                    case -127: {
                        subject = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block16;
                    }
                    case -126: {
                        fullBefore = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block16;
                    }
                    case -125: {
                        fullAfter = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block16;
                    }
                    case -124: {
                        compactBefore = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block16;
                    }
                    case -123: {
                        compactAfter = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block16;
                    }
                    case -90: {
                        for (ASN1Element pdmElement : ASN1Sequence.decodeAsSequence(elements[i]).elements()) {
                            ASN1Element[] dmElements = ASN1Sequence.decodeAsSequence(pdmElement).elements();
                            String name = ASN1OctetString.decodeAsOctetString(dmElements[0]).stringValue();
                            String recipientID = dmElements.length > 1 ? ASN1OctetString.decodeAsOctetString(dmElements[1]).stringValue() : null;
                            pdmList.add(new ObjectPair<String, String>(name, recipientID));
                        }
                        continue block16;
                    }
                    case -121: {
                        ifPasswordExpired = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block16;
                    }
                    case -120: {
                        ifAccountLocked = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block16;
                    }
                    case -119: {
                        ifAccountDisabled = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block16;
                    }
                    case -118: {
                        ifAccountExpired = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block16;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_SINGLE_USE_TOKEN_REQUEST_UNKNOWN_ELEMENT.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            this.validityDurationMillis = validityDuration;
            this.messageSubject = subject;
            this.fullTextBeforeToken = fullBefore;
            this.fullTextAfterToken = fullAfter;
            this.compactTextBeforeToken = compactBefore;
            this.compactTextAfterToken = compactAfter;
            this.preferredDeliveryMechanisms = Collections.unmodifiableList(pdmList);
            this.deliverIfPasswordExpired = ifPasswordExpired;
            this.deliverIfAccountLocked = ifAccountLocked;
            this.deliverIfAccountDisabled = ifAccountDisabled;
            this.deliverIfAccountExpired = ifAccountExpired;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_SINGLE_USE_TOKEN_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull String userDN, @NotNull String tokenID, @Nullable Long validityDurationMillis, @Nullable String messageSubject, @Nullable String fullTextBeforeToken, @Nullable String fullTextAfterToken, @Nullable String compactTextBeforeToken, @Nullable String compactTextAfterToken, @Nullable List<ObjectPair<String, String>> preferredDeliveryMechanisms, boolean deliverIfPasswordExpired, boolean deliverIfAccountLocked, boolean deliverIfAccountDisabled, boolean deliverIfAccountExpired) {
        Validator.ensureNotNull(userDN);
        Validator.ensureNotNull(tokenID);
        if (validityDurationMillis != null) {
            Validator.ensureTrue(validityDurationMillis > 0L);
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(13);
        elements.add(new ASN1OctetString(userDN));
        elements.add(new ASN1OctetString(tokenID));
        if (validityDurationMillis != null) {
            elements.add(new ASN1Long(-128, validityDurationMillis));
        }
        if (messageSubject != null) {
            elements.add(new ASN1OctetString(-127, messageSubject));
        }
        if (fullTextBeforeToken != null) {
            elements.add(new ASN1OctetString(-126, fullTextBeforeToken));
        }
        if (fullTextAfterToken != null) {
            elements.add(new ASN1OctetString(-125, fullTextAfterToken));
        }
        if (compactTextBeforeToken != null) {
            elements.add(new ASN1OctetString(-124, compactTextBeforeToken));
        }
        if (compactTextAfterToken != null) {
            elements.add(new ASN1OctetString(-123, compactTextAfterToken));
        }
        if (preferredDeliveryMechanisms != null && !preferredDeliveryMechanisms.isEmpty()) {
            ArrayList<ASN1Sequence> pdmElements = new ArrayList<ASN1Sequence>(preferredDeliveryMechanisms.size());
            for (ObjectPair<String, String> p : preferredDeliveryMechanisms) {
                ArrayList<ASN1OctetString> l = new ArrayList<ASN1OctetString>(2);
                l.add(new ASN1OctetString(p.getFirst()));
                if (p.getSecond() != null) {
                    l.add(new ASN1OctetString(p.getSecond()));
                }
                pdmElements.add(new ASN1Sequence(l));
            }
            elements.add(new ASN1Sequence(-90, pdmElements));
        }
        if (deliverIfPasswordExpired) {
            elements.add(new ASN1Boolean(-121, true));
        }
        if (deliverIfAccountLocked) {
            elements.add(new ASN1Boolean(-120, true));
        }
        if (deliverIfAccountDisabled) {
            elements.add(new ASN1Boolean(-119, true));
        }
        if (deliverIfAccountExpired) {
            elements.add(new ASN1Boolean(-118, true));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public String getUserDN() {
        return this.userDN;
    }

    @NotNull
    public String getTokenID() {
        return this.tokenID;
    }

    @Nullable
    public Long getValidityDurationMillis() {
        return this.validityDurationMillis;
    }

    @Nullable
    public String getMessageSubject() {
        return this.messageSubject;
    }

    @Nullable
    public String getFullTextBeforeToken() {
        return this.fullTextBeforeToken;
    }

    @Nullable
    public String getFullTextAfterToken() {
        return this.fullTextAfterToken;
    }

    @Nullable
    public String getCompactTextBeforeToken() {
        return this.compactTextBeforeToken;
    }

    @Nullable
    public String getCompactTextAfterToken() {
        return this.compactTextAfterToken;
    }

    @NotNull
    public List<ObjectPair<String, String>> getPreferredDeliveryMechanisms() {
        return this.preferredDeliveryMechanisms;
    }

    public boolean deliverIfPasswordExpired() {
        return this.deliverIfPasswordExpired;
    }

    public boolean deliverIfAccountLocked() {
        return this.deliverIfAccountLocked;
    }

    public boolean deliverIfAccountDisabled() {
        return this.deliverIfAccountDisabled;
    }

    public boolean deliverIfAccountExpired() {
        return this.deliverIfAccountExpired;
    }

    @Override
    @NotNull
    public DeliverSingleUseTokenExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new DeliverSingleUseTokenExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public DeliverSingleUseTokenExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public DeliverSingleUseTokenExtendedRequest duplicate(@Nullable Control[] controls) {
        DeliverSingleUseTokenExtendedRequest r = new DeliverSingleUseTokenExtendedRequest(this.userDN, this.tokenID, this.validityDurationMillis, this.messageSubject, this.fullTextBeforeToken, this.fullTextAfterToken, this.compactTextBeforeToken, this.compactTextAfterToken, this.preferredDeliveryMechanisms, this.deliverIfPasswordExpired, this.deliverIfAccountLocked, this.deliverIfAccountDisabled, this.deliverIfAccountExpired, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_DELIVER_SINGLE_USE_TOKEN.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("DeliverSingleUseTokenExtendedRequest(userDN='");
        buffer.append(this.userDN);
        buffer.append("', tokenID='");
        buffer.append(this.tokenID);
        buffer.append('\'');
        if (this.validityDurationMillis != null) {
            buffer.append(", validityDurationMillis=");
            buffer.append(this.validityDurationMillis);
        }
        if (this.messageSubject != null) {
            buffer.append(", messageSubject='");
            buffer.append(this.messageSubject);
            buffer.append('\'');
        }
        if (this.fullTextBeforeToken != null) {
            buffer.append(", fullTextBeforeToken='");
            buffer.append(this.fullTextBeforeToken);
            buffer.append('\'');
        }
        if (this.fullTextAfterToken != null) {
            buffer.append(", fullTextAfterToken='");
            buffer.append(this.fullTextAfterToken);
            buffer.append('\'');
        }
        if (this.compactTextBeforeToken != null) {
            buffer.append(", compactTextBeforeToken='");
            buffer.append(this.compactTextBeforeToken);
            buffer.append('\'');
        }
        if (this.compactTextAfterToken != null) {
            buffer.append(", compactTextAfterToken='");
            buffer.append(this.compactTextAfterToken);
            buffer.append('\'');
        }
        if (this.preferredDeliveryMechanisms != null) {
            buffer.append(", preferredDeliveryMechanisms={");
            Iterator<ObjectPair<String, String>> iterator = this.preferredDeliveryMechanisms.iterator();
            while (iterator.hasNext()) {
                ObjectPair<String, String> p = iterator.next();
                buffer.append('\'');
                buffer.append(p.getFirst());
                if (p.getSecond() != null) {
                    buffer.append('(');
                    buffer.append(p.getSecond());
                    buffer.append(')');
                }
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
        }
        buffer.append(", deliverIfPasswordExpired=");
        buffer.append(this.deliverIfPasswordExpired);
        buffer.append(", deliverIfAccountLocked=");
        buffer.append(this.deliverIfAccountLocked);
        buffer.append(", deliverIfAccountDisabled=");
        buffer.append(this.deliverIfAccountDisabled);
        buffer.append(", deliverIfAccountExpired=");
        buffer.append(this.deliverIfAccountExpired);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

