/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.vectors;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.search.vectors.QueryVectorBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.CoordinatedInferenceAction;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelPrefixStrings;
import org.elasticsearch.xpack.core.ml.inference.results.TextEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.WarningInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextEmbeddingConfigUpdate;

public class TextEmbeddingQueryVectorBuilder
implements QueryVectorBuilder {
    public static final String NAME = "text_embedding";
    public static final ParseField MODEL_TEXT = new ParseField("model_text", new String[0]);
    public static final ConstructingObjectParser<TextEmbeddingQueryVectorBuilder, Void> PARSER = new ConstructingObjectParser("text_embedding", args -> new TextEmbeddingQueryVectorBuilder((String)args[0], (String)args[1]));
    private final String modelId;
    private final String modelText;

    public static TextEmbeddingQueryVectorBuilder fromXContent(XContentParser parser) throws IOException {
        return (TextEmbeddingQueryVectorBuilder)PARSER.parse(parser, null);
    }

    public TextEmbeddingQueryVectorBuilder(String modelId, String modelText) {
        this.modelId = modelId;
        this.modelText = modelText;
    }

    public TextEmbeddingQueryVectorBuilder(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.modelText = in.readString();
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_7_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeString(this.modelText);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TrainedModelConfig.MODEL_ID.getPreferredName(), this.modelId);
        builder.field(MODEL_TEXT.getPreferredName(), this.modelText);
        builder.endObject();
        return builder;
    }

    public void buildVector(Client client, ActionListener<float[]> listener) {
        CoordinatedInferenceAction.Request inferRequest = CoordinatedInferenceAction.Request.forTextInput((String)this.modelId, List.of(this.modelText), (InferenceConfigUpdate)TextEmbeddingConfigUpdate.EMPTY_INSTANCE, (Boolean)false, (TimeValue)InferModelAction.Request.DEFAULT_TIMEOUT_FOR_API);
        inferRequest.setHighPriority(true);
        inferRequest.setPrefixType(TrainedModelPrefixStrings.PrefixType.SEARCH);
        ClientHelper.executeAsyncWithOrigin((Client)client, (String)"ml", (ActionType)CoordinatedInferenceAction.INSTANCE, (ActionRequest)inferRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.getInferenceResults().isEmpty()) {
                listener.onFailure((Exception)new IllegalStateException("text embedding inference response contain no results"));
                return;
            }
            Object patt4501$temp = response.getInferenceResults().get(0);
            if (patt4501$temp instanceof TextEmbeddingResults) {
                TextEmbeddingResults textEmbeddingResults = (TextEmbeddingResults)patt4501$temp;
                listener.onResponse((Object)textEmbeddingResults.getInferenceAsFloat());
            } else {
                Object patt4699$temp = response.getInferenceResults().get(0);
                if (patt4699$temp instanceof WarningInferenceResults) {
                    WarningInferenceResults warning = (WarningInferenceResults)patt4699$temp;
                    listener.onFailure((Exception)new IllegalStateException(warning.getWarning()));
                } else {
                    throw new IllegalStateException("expected a result of type [text_embedding_result] received [" + ((InferenceResults)response.getInferenceResults().get(0)).getWriteableName() + "]. Is [" + this.modelId + "] a text embedding model?");
                }
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public String getModelText() {
        return this.modelText;
    }

    public String getModelId() {
        return this.modelId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextEmbeddingQueryVectorBuilder that = (TextEmbeddingQueryVectorBuilder)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.modelText, that.modelText);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.modelText);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TrainedModelConfig.MODEL_ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MODEL_TEXT);
    }
}

