/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.inference;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutTrainedModelAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)("/_ml/trained_models/{" + TrainedModelConfig.MODEL_ID + "}")).replaces(RestRequest.Method.PUT, "/_ml/inference/{" + TrainedModelConfig.MODEL_ID + "}", RestApiVersion.V_8).build());
    }

    public String getName() {
        return "xpack_ml_put_trained_model_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String id = restRequest.param(TrainedModelConfig.MODEL_ID.getPreferredName());
        XContentParser parser = restRequest.contentParser();
        boolean deferDefinitionDecompression = restRequest.paramAsBoolean("defer_definition_decompression", false);
        boolean waitForCompletion = restRequest.paramAsBoolean("wait_for_completion", false);
        PutTrainedModelAction.Request putRequest = PutTrainedModelAction.Request.parseRequest((String)id, (boolean)deferDefinitionDecompression, (boolean)waitForCompletion, (XContentParser)parser);
        putRequest.timeout(restRequest.paramAsTime("timeout", putRequest.timeout()));
        return channel -> client.execute((ActionType)PutTrainedModelAction.INSTANCE, (ActionRequest)putRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

