/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.ltr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionDISIApproximation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.xpack.ml.inference.ltr.FeatureExtractor;

public class QueryFeatureExtractor
implements FeatureExtractor {
    private final List<String> featureNames;
    private final List<Weight> weights;
    private final List<Scorer> scorers;
    private DisjunctionDISIApproximation rankerIterator;

    public QueryFeatureExtractor(List<String> featureNames, List<Weight> weights) {
        if (featureNames.size() != weights.size()) {
            throw new IllegalArgumentException("[featureNames] and [weights] must be the same size.");
        }
        this.featureNames = featureNames;
        this.weights = weights;
        this.scorers = new ArrayList<Scorer>(weights.size());
    }

    @Override
    public void setNextReader(LeafReaderContext segmentContext) throws IOException {
        DisiPriorityQueue disiPriorityQueue = new DisiPriorityQueue(this.weights.size());
        this.scorers.clear();
        for (Weight weight : this.weights) {
            if (weight == null) {
                this.scorers.add(null);
                continue;
            }
            Scorer scorer = weight.scorer(segmentContext);
            if (scorer != null) {
                disiPriorityQueue.add(new DisiWrapper(scorer));
            }
            this.scorers.add(scorer);
        }
        this.rankerIterator = new DisjunctionDISIApproximation(disiPriorityQueue);
    }

    @Override
    public void addFeatures(Map<String, Object> featureMap, int docId) throws IOException {
        this.rankerIterator.advance(docId);
        for (int i = 0; i < this.featureNames.size(); ++i) {
            Scorer scorer = this.scorers.get(i);
            if (scorer == null || scorer.docID() != docId) continue;
            featureMap.put(this.featureNames.get(i), Float.valueOf(scorer.score()));
        }
    }

    @Override
    public List<String> featureNames() {
        return this.featureNames;
    }
}

