/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Strings;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfigUtils;
import org.elasticsearch.xpack.core.ml.datafeed.SearchInterval;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorUtils;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AbstractAggregationDataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregatedSearchRequestBuilder;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationToJsonProcessor;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.CompositeAggregationDataExtractorContext;

class CompositeAggregationDataExtractor
implements DataExtractor {
    private static final Logger LOGGER = LogManager.getLogger(CompositeAggregationDataExtractor.class);
    private volatile Map<String, Object> afterKey = null;
    private final CompositeAggregationBuilder compositeAggregationBuilder;
    private final Client client;
    private final CompositeAggregationDataExtractorContext context;
    private final DatafeedTimingStatsReporter timingStatsReporter;
    private final AggregatedSearchRequestBuilder requestBuilder;
    private final long interval;
    private volatile boolean isCancelled;
    private volatile long nextBucketOnCancel;
    private boolean hasNext;

    CompositeAggregationDataExtractor(CompositeAggregationBuilder compositeAggregationBuilder, Client client, CompositeAggregationDataExtractorContext dataExtractorContext, DatafeedTimingStatsReporter timingStatsReporter, AggregatedSearchRequestBuilder requestBuilder) {
        this.compositeAggregationBuilder = Objects.requireNonNull(compositeAggregationBuilder);
        this.client = Objects.requireNonNull(client);
        this.context = Objects.requireNonNull(dataExtractorContext);
        this.timingStatsReporter = Objects.requireNonNull(timingStatsReporter);
        this.requestBuilder = Objects.requireNonNull(requestBuilder);
        this.interval = DatafeedConfigUtils.getHistogramIntervalMillis((AggregationBuilder)compositeAggregationBuilder);
        this.hasNext = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void cancel() {
        LOGGER.debug("[{}] Data extractor received cancel request", (Object)this.context.jobId);
        this.isCancelled = true;
    }

    @Override
    public void destroy() {
        this.cancel();
    }

    @Override
    public long getEndTime() {
        return this.context.queryContext.end;
    }

    @Override
    public DataExtractor.Result next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SearchInterval searchInterval = new SearchInterval(this.context.queryContext.start, this.context.queryContext.end);
        InternalAggregations aggs = this.search();
        if (aggs == null) {
            LOGGER.trace("[{}] extraction finished", (Object)this.context.jobId);
            this.hasNext = false;
            this.afterKey = null;
            return new DataExtractor.Result(searchInterval, Optional.empty());
        }
        return new DataExtractor.Result(searchInterval, Optional.of(this.processAggs(aggs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalAggregations search() {
        LOGGER.trace(() -> Strings.format((String)"[%s] Executing composite aggregated search from [%s] to [%s]", (Object[])new Object[]{this.context.jobId, this.context.queryContext.start, this.context.queryContext.end}));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query(DataExtractorUtils.wrapInTimeRangeQuery(this.context.queryContext.query, this.context.queryContext.timeField, this.context.queryContext.start, this.context.queryContext.end));
        if (!this.context.queryContext.runtimeMappings.isEmpty()) {
            searchSourceBuilder.runtimeMappings(this.context.queryContext.runtimeMappings);
        }
        if (this.afterKey != null) {
            this.compositeAggregationBuilder.aggregateAfter(this.afterKey);
        }
        searchSourceBuilder.aggregation((AggregationBuilder)this.compositeAggregationBuilder);
        ActionRequestBuilder<SearchRequest, SearchResponse> searchRequest = this.requestBuilder.build(searchSourceBuilder);
        SearchResponse searchResponse = AbstractAggregationDataExtractor.executeSearchRequest(this.client, this.context.queryContext, searchRequest);
        try {
            LOGGER.trace("[{}] Search composite response was obtained", (Object)this.context.jobId);
            this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
            InternalAggregations aggregations = searchResponse.getAggregations();
            if (aggregations == null) {
                InternalAggregations internalAggregations = null;
                return internalAggregations;
            }
            CompositeAggregation compositeAgg = (CompositeAggregation)aggregations.get(this.compositeAggregationBuilder.getName());
            if (compositeAgg == null || compositeAgg.getBuckets().isEmpty()) {
                InternalAggregations internalAggregations = null;
                return internalAggregations;
            }
            InternalAggregations internalAggregations = aggregations;
            return internalAggregations;
        }
        finally {
            searchResponse.decRef();
        }
    }

    private InputStream processAggs(InternalAggregations aggs) throws IOException {
        AggregationToJsonProcessor aggregationToJsonProcessor = new AggregationToJsonProcessor(this.context.queryContext.timeField, this.context.fields, this.context.includeDocCount, this.context.queryContext.start, this.context.compositeAggDateHistogramGroupSourceName);
        LOGGER.trace(() -> Strings.format((String)"[%s] got [%s] composite buckets", (Object[])new Object[]{this.context.jobId, ((CompositeAggregation)aggs.get(this.compositeAggregationBuilder.getName())).getBuckets().size()}));
        aggregationToJsonProcessor.process(aggs);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Long afterKeyTimeBucket = this.afterKey != null ? (Long)this.afterKey.get(this.context.compositeAggDateHistogramGroupSourceName) : null;
        boolean cancellable = aggregationToJsonProcessor.writeAllDocsCancellable(timestamp -> {
            if (this.isCancelled) {
                if (afterKeyTimeBucket == null) {
                    return true;
                }
                if (this.nextBucketOnCancel == 0L) {
                    this.nextBucketOnCancel = Intervals.alignToFloor((long)(timestamp + this.interval), (long)this.interval);
                    LOGGER.debug(() -> Strings.format((String)"[%s] set future timestamp cancel to [%s] via timestamp [%s]", (Object[])new Object[]{this.context.jobId, this.nextBucketOnCancel, timestamp}));
                }
                return timestamp >= this.nextBucketOnCancel;
            }
            return false;
        }, outputStream);
        if (this.isCancelled && cancellable) {
            LOGGER.debug(() -> Strings.format((String)"[%s] cancelled before bucket [%s] on date_histogram page [%s]", (Object[])new Object[]{this.context.jobId, this.nextBucketOnCancel, afterKeyTimeBucket != null ? afterKeyTimeBucket : "__null__"}));
            this.hasNext = false;
        }
        CompositeAggregation compositeAgg = (CompositeAggregation)aggs.get(this.compositeAggregationBuilder.getName());
        this.afterKey = compositeAgg.afterKey();
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataExtractor.DataSummary getSummary() {
        SearchRequestBuilder searchRequestBuilder = DataExtractorUtils.getSearchRequestBuilderForSummary(this.client, this.context.queryContext);
        SearchResponse searchResponse = AbstractAggregationDataExtractor.executeSearchRequest(this.client, this.context.queryContext, (ActionRequestBuilder<SearchRequest, SearchResponse>)searchRequestBuilder);
        try {
            LOGGER.debug("[{}] Aggregating Data summary response was obtained", (Object)this.context.jobId);
            this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
            DataExtractor.DataSummary dataSummary = DataExtractorUtils.getDataSummary(searchResponse);
            return dataSummary;
        }
        finally {
            searchResponse.decRef();
        }
    }
}

