/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Set;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.action.UpdateCalendarJobAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportUpdateCalendarJobAction
extends HandledTransportAction<UpdateCalendarJobAction.Request, PutCalendarAction.Response> {
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;

    @Inject
    public TransportUpdateCalendarJobAction(TransportService transportService, ActionFilters actionFilters, JobResultsProvider jobResultsProvider, JobManager jobManager) {
        super("cluster:admin/xpack/ml/calendars/jobs/update", transportService, actionFilters, UpdateCalendarJobAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.jobResultsProvider = jobResultsProvider;
        this.jobManager = jobManager;
    }

    protected void doExecute(Task task, UpdateCalendarJobAction.Request request, ActionListener<PutCalendarAction.Response> listener) {
        Set jobIdsToAdd = Strings.tokenizeByCommaToSet((String)request.getJobIdsToAddExpression());
        Set jobIdsToRemove = Strings.tokenizeByCommaToSet((String)request.getJobIdsToRemoveExpression());
        this.jobResultsProvider.updateCalendar(request.getCalendarId(), jobIdsToAdd, jobIdsToRemove, c -> this.jobManager.updateProcessOnCalendarChanged(c.getJobIds(), (ActionListener<Boolean>)ActionListener.wrap(r -> listener.onResponse((Object)new PutCalendarAction.Response(c)), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
    }
}

