/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.PreviewDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetector;
import org.elasticsearch.xpack.ml.dataframe.extractor.ExtractedFieldsDetectorFactory;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.utils.SecondaryAuthorizationUtils;

public class TransportPreviewDataFrameAnalyticsAction
extends HandledTransportAction<PreviewDataFrameAnalyticsAction.Request, PreviewDataFrameAnalyticsAction.Response> {
    private final XPackLicenseState licenseState;
    private final NodeClient client;
    private final SecurityContext securityContext;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final ClusterService clusterService;

    @Inject
    public TransportPreviewDataFrameAnalyticsAction(TransportService transportService, ActionFilters actionFilters, NodeClient client, XPackLicenseState licenseState, Settings settings, ThreadPool threadPool, ClusterService clusterService) {
        super("cluster:admin/xpack/ml/data_frame/analytics/preview", transportService, actionFilters, PreviewDataFrameAnalyticsAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = Objects.requireNonNull(client);
        this.licenseState = licenseState;
        this.threadPool = threadPool;
        this.settings = settings;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.clusterService = clusterService;
    }

    private static Map<String, Object> mergeRow(DataFrameDataExtractor.Row row, List<String> fieldNames) {
        return row.getValues() == null ? Collections.emptyMap() : IntStream.range(0, row.getValues().length).boxed().collect(Collectors.toMap(fieldNames::get, i -> row.getValues()[i]));
    }

    protected void doExecute(Task task, PreviewDataFrameAnalyticsAction.Request request, ActionListener<PreviewDataFrameAnalyticsAction.Response> listener) {
        if (!MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
            SecondaryAuthorizationUtils.useSecondaryAuthIfAvailable(this.securityContext, () -> {
                DataFrameAnalyticsConfig config = new DataFrameAnalyticsConfig.Builder(request.getConfig()).setHeaders(ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.threadPool.getThreadContext(), (ClusterState)this.clusterService.state())).build();
                this.preview(task, config, listener);
            });
        } else {
            this.preview(task, request.getConfig(), (ActionListener<PreviewDataFrameAnalyticsAction.Response>)ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.threadPool.getThreadContext()));
        }
    }

    void preview(Task task, DataFrameAnalyticsConfig config, ActionListener<PreviewDataFrameAnalyticsAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ExtractedFieldsDetectorFactory extractedFieldsDetectorFactory = new ExtractedFieldsDetectorFactory((Client)new ParentTaskAssigningClient((Client)this.client, parentTaskId));
        extractedFieldsDetectorFactory.createFromSource(config, (ActionListener<ExtractedFieldsDetector>)listener.delegateFailureAndWrap((delegate, extractedFieldsDetector) -> {
            DataFrameDataExtractor extractor = DataFrameDataExtractorFactory.createForSourceIndices((Client)this.client, parentTaskId.toString(), config, (ExtractedFields)extractedFieldsDetector.detect().v1()).newExtractor(false);
            extractor.preview((ActionListener<List<DataFrameDataExtractor.Row>>)delegate.delegateFailureAndWrap((l, rows) -> {
                List<String> fieldNames = extractor.getFieldNames();
                l.onResponse((Object)new PreviewDataFrameAnalyticsAction.Response(rows.stream().map(r -> TransportPreviewDataFrameAnalyticsAction.mergeRow(r, fieldNames)).collect(Collectors.toList())));
            }));
        }));
    }
}

