/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.MlInfoAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.CategorizationAnalyzerConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.job.NodeLoadDetector;
import org.elasticsearch.xpack.ml.process.MlControllerHolder;
import org.elasticsearch.xpack.ml.utils.MlProcessors;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;

public class TransportMlInfoAction
extends HandledTransportAction<MlInfoAction.Request, MlInfoAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportMlInfoAction.class);
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;
    private final Map<String, Object> nativeCodeInfo;

    @Inject
    public TransportMlInfoAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedXContentRegistry xContentRegistry, MlControllerHolder mlControllerHolder) {
        super("cluster:monitor/xpack/ml/info/get", transportService, actionFilters, MlInfoAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        try {
            this.nativeCodeInfo = mlControllerHolder.getMlController().getNativeCodeInfo();
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Could not get native code info from native controller", e);
        }
    }

    protected void doExecute(Task task, MlInfoAction.Request request, ActionListener<MlInfoAction.Response> listener) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("defaults", this.defaults());
        info.put("limits", this.limits());
        info.put("native_code", this.nativeCodeInfo);
        info.put(MlMetadata.UPGRADE_MODE.getPreferredName(), this.upgradeMode());
        listener.onResponse((Object)new MlInfoAction.Response(info));
    }

    private Map<String, Object> defaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("anomaly_detectors", this.anomalyDetectorsDefaults());
        defaults.put("datafeeds", TransportMlInfoAction.datafeedsDefaults());
        return defaults;
    }

    private boolean upgradeMode() {
        return MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isUpgradeMode();
    }

    private Map<String, Object> anomalyDetectorsDefaults() {
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        defaults.put(AnalysisLimits.MODEL_MEMORY_LIMIT.getPreferredName(), this.defaultModelMemoryLimit());
        defaults.put(AnalysisLimits.CATEGORIZATION_EXAMPLES_LIMIT.getPreferredName(), 4L);
        defaults.put(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), 10L);
        defaults.put(Job.DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS.getPreferredName(), 1L);
        try {
            defaults.put(CategorizationAnalyzerConfig.CATEGORIZATION_ANALYZER.getPreferredName(), CategorizationAnalyzerConfig.buildStandardCategorizationAnalyzer(Collections.emptyList()).asMap(this.xContentRegistry).get(CategorizationAnalyzerConfig.CATEGORIZATION_ANALYZER.getPreferredName()));
        }
        catch (IOException e) {
            logger.error("failed to convert default categorization analyzer to map", (Throwable)e);
        }
        return defaults;
    }

    private ByteSizeValue defaultModelMemoryLimit() {
        ByteSizeValue defaultLimit = ByteSizeValue.ofMb((long)1024L);
        ByteSizeValue maxModelMemoryLimit = NativeMemoryCalculator.getMaxModelMemoryLimit(this.clusterService);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L && maxModelMemoryLimit.getBytes() < defaultLimit.getBytes()) {
            return maxModelMemoryLimit;
        }
        return defaultLimit;
    }

    private static Map<String, Object> datafeedsDefaults() {
        HashMap<String, Object> anomalyDetectorsDefaults = new HashMap<String, Object>();
        anomalyDetectorsDefaults.put(DatafeedConfig.SCROLL_SIZE.getPreferredName(), 1000);
        return anomalyDetectorsDefaults;
    }

    private Map<String, Object> limits() {
        ClusterSettings clusterSettings = this.clusterService.getClusterSettings();
        DiscoveryNodes nodes = this.clusterService.state().getNodes();
        HashMap<String, Object> limits = new HashMap<String, Object>();
        ByteSizeValue effectiveMaxModelMemoryLimit = NativeMemoryCalculator.calculateMaxModelMemoryLimitToFit(clusterSettings, nodes);
        ByteSizeValue maxModelMemoryLimit = NativeMemoryCalculator.getMaxModelMemoryLimit(this.clusterService);
        if (maxModelMemoryLimit != null && maxModelMemoryLimit.getBytes() > 0L) {
            limits.put("max_model_memory_limit", maxModelMemoryLimit.getStringRep());
            if (effectiveMaxModelMemoryLimit == null || effectiveMaxModelMemoryLimit.compareTo(maxModelMemoryLimit) > 0) {
                effectiveMaxModelMemoryLimit = maxModelMemoryLimit;
            }
        }
        if (effectiveMaxModelMemoryLimit != null) {
            limits.put("effective_max_model_memory_limit", effectiveMaxModelMemoryLimit.getStringRep());
        }
        limits.put("total_ml_memory", NativeMemoryCalculator.calculateTotalMlMemory(clusterSettings, nodes).getStringRep());
        List<DiscoveryNode> mlNodes = nodes.stream().filter(MachineLearning::isMlNode).toList();
        if (TransportMlInfoAction.areMlNodesBiggestSize((ByteSizeValue)clusterSettings.get(MachineLearning.MAX_ML_NODE_SIZE), mlNodes)) {
            Processors totalMlProcessors;
            Processors singleNodeProcessors = MlProcessors.getMaxMlNodeProcessors(nodes, (Integer)clusterSettings.get(MachineLearning.ALLOCATED_PROCESSORS_SCALE));
            if (singleNodeProcessors.count() > 0.0) {
                limits.put("max_single_ml_node_processors", singleNodeProcessors.roundUp());
            }
            if ((totalMlProcessors = MlProcessors.getTotalMlNodeProcessors(nodes, (Integer)clusterSettings.get(MachineLearning.ALLOCATED_PROCESSORS_SCALE))).count() > 0.0) {
                int potentialExtraProcessors = Math.max(0, (Integer)clusterSettings.get(MachineLearning.MAX_LAZY_ML_NODES) - mlNodes.size()) * singleNodeProcessors.roundUp();
                limits.put("total_ml_processors", totalMlProcessors.roundUp() + potentialExtraProcessors);
            }
        }
        return limits;
    }

    static boolean areMlNodesBiggestSize(ByteSizeValue maxMLNodeSize, Collection<DiscoveryNode> mlNodes) {
        if (maxMLNodeSize.getBytes() == 0L) {
            return true;
        }
        OptionalLong smallestMLNode = mlNodes.stream().map(NodeLoadDetector::getNodeSize).flatMapToLong(OptionalLong::stream).min();
        return smallestMLNode.isPresent() && smallestMLNode.getAsLong() >= maxMLNodeSize.getBytes();
    }
}

