/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedRunningStateAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportGetDatafeedsStatsAction
extends HandledTransportAction<GetDatafeedsStatsAction.Request, GetDatafeedsStatsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetDatafeedsStatsAction.class);
    private final ClusterService clusterService;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobResultsProvider jobResultsProvider;
    private final OriginSettingClient client;

    @Inject
    public TransportGetDatafeedsStatsAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, DatafeedConfigProvider datafeedConfigProvider, JobResultsProvider jobResultsProvider, Client client) {
        super("cluster:monitor/xpack/ml/datafeeds/stats/get", transportService, actionFilters, GetDatafeedsStatsAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.jobResultsProvider = jobResultsProvider;
        this.client = new OriginSettingClient(client, "ml");
    }

    protected void doExecute(Task task, GetDatafeedsStatsAction.Request request, ActionListener<GetDatafeedsStatsAction.Response> listener) {
        logger.trace(() -> "[" + request.getDatafeedId() + "] get stats for datafeed");
        ClusterState state = this.clusterService.state();
        PersistentTasksCustomMetadata tasksInProgress = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        GetDatafeedsStatsAction.Response.Builder responseBuilder = new GetDatafeedsStatsAction.Response.Builder();
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ActionListener runtimeStateListener = ActionListener.wrap(runtimeStateResponse -> {
            responseBuilder.setDatafeedRuntimeState(runtimeStateResponse);
            listener.onResponse((Object)responseBuilder.build(tasksInProgress, state));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener datafeedTimingStatsListener = ActionListener.wrap(timingStatsByJobId -> {
            responseBuilder.setTimingStatsMap(timingStatsByJobId);
            GetDatafeedRunningStateAction.Request datafeedRunningStateAction = new GetDatafeedRunningStateAction.Request(responseBuilder.getDatafeedIds());
            datafeedRunningStateAction.setParentTask(parentTaskId);
            this.client.execute((ActionType)GetDatafeedRunningStateAction.INSTANCE, (ActionRequest)new GetDatafeedRunningStateAction.Request(responseBuilder.getDatafeedIds()), runtimeStateListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener expandedConfigsListener = ActionListener.wrap(datafeedBuilders -> {
            Map<String, String> datafeedIdsToJobIds = datafeedBuilders.stream().collect(Collectors.toMap(DatafeedConfig.Builder::getId, DatafeedConfig.Builder::getJobId));
            responseBuilder.setDatafeedToJobId(datafeedIdsToJobIds);
            this.jobResultsProvider.datafeedTimingStats(new ArrayList<String>(datafeedIdsToJobIds.values()), parentTaskId, (ActionListener<Map<String, DatafeedTimingStats>>)datafeedTimingStatsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener expandIdsListener = ActionListener.wrap(expandedIds -> {
            responseBuilder.setDatafeedIds((Collection)expandedIds);
            this.datafeedConfigProvider.expandDatafeedConfigs(request.getDatafeedId(), true, parentTaskId, (ActionListener<List<DatafeedConfig.Builder>>)expandedConfigsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        this.datafeedConfigProvider.expandDatafeedIds(request.getDatafeedId(), request.allowNoMatch(), tasksInProgress, true, parentTaskId, (ActionListener<SortedSet<String>>)expandIdsListener);
    }
}

