/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsDeleter;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportDeleteDataFrameAnalyticsAction
extends AcknowledgedTransportMasterNodeAction<DeleteDataFrameAnalyticsAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteDataFrameAnalyticsAction.class);
    private final Client client;
    private final MlMemoryTracker memoryTracker;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final DataFrameAnalyticsAuditor auditor;

    @Inject
    public TransportDeleteDataFrameAnalyticsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, MlMemoryTracker memoryTracker, DataFrameAnalyticsConfigProvider configProvider, DataFrameAnalyticsAuditor auditor) {
        super("cluster:admin/xpack/ml/data_frame/analytics/delete", transportService, clusterService, threadPool, actionFilters, DeleteDataFrameAnalyticsAction.Request::new, indexNameExpressionResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.memoryTracker = memoryTracker;
        this.configProvider = configProvider;
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected void masterOperation(Task task, DeleteDataFrameAnalyticsAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient(this.client, taskId);
        if (request.isForce()) {
            this.forceDelete(parentTaskClient, request, listener);
        } else {
            this.normalDelete(parentTaskClient, state, request, listener);
        }
    }

    private void forceDelete(ParentTaskAssigningClient parentTaskClient, DeleteDataFrameAnalyticsAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        logger.debug("[{}] Force deleting data frame analytics job", (Object)request.getId());
        ActionListener stopListener = listener.delegateFailureAndWrap((l, stopResponse) -> this.normalDelete(parentTaskClient, this.clusterService.state(), request, (ActionListener<AcknowledgedResponse>)l));
        TransportDeleteDataFrameAnalyticsAction.stopJob(parentTaskClient, request, (ActionListener<StopDataFrameAnalyticsAction.Response>)stopListener);
    }

    private static void stopJob(ParentTaskAssigningClient parentTaskClient, DeleteDataFrameAnalyticsAction.Request request, ActionListener<StopDataFrameAnalyticsAction.Response> listener) {
        StopDataFrameAnalyticsAction.Request stopRequest = new StopDataFrameAnalyticsAction.Request(request.getId());
        stopRequest.setTimeout(request.timeout());
        ActionListener normalStopListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), normalStopFailure -> {
            stopRequest.setForce(true);
            ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)StopDataFrameAnalyticsAction.INSTANCE, (ActionRequest)stopRequest, (ActionListener)ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), forceStopFailure -> {
                logger.error(() -> "[" + request.getId() + "] Failed to stop normally", (Throwable)normalStopFailure);
                logger.error(() -> "[" + request.getId() + "] Failed to stop forcefully", (Throwable)forceStopFailure);
                listener.onFailure(forceStopFailure);
            }));
        });
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)StopDataFrameAnalyticsAction.INSTANCE, (ActionRequest)stopRequest, (ActionListener)normalStopListener);
    }

    private void normalDelete(ParentTaskAssigningClient parentTaskClient, ClusterState state, DeleteDataFrameAnalyticsAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        PersistentTasksCustomMetadata tasks;
        String id = request.getId();
        DataFrameAnalyticsState taskState = MlTasks.getDataFrameAnalyticsState((String)id, (PersistentTasksCustomMetadata)(tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks")));
        if (taskState != DataFrameAnalyticsState.STOPPED) {
            listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)"Cannot delete data frame analytics [{}] while its status is [{}]", (Object[])new Object[]{id, taskState}));
            return;
        }
        this.memoryTracker.removeDataFrameAnalyticsJob(id);
        this.configProvider.get(id, (ActionListener<DataFrameAnalyticsConfig>)listener.delegateFailureAndWrap((l, config) -> {
            DataFrameAnalyticsDeleter deleter = new DataFrameAnalyticsDeleter((Client)parentTaskClient, this.auditor);
            deleter.deleteAllDocuments((DataFrameAnalyticsConfig)config, request.timeout(), (ActionListener<AcknowledgedResponse>)l);
        }));
    }

    protected ClusterBlockException checkBlock(DeleteDataFrameAnalyticsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

