/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarEventAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportDeleteCalendarEventAction
extends HandledTransportAction<DeleteCalendarEventAction.Request, AcknowledgedResponse> {
    private final Client client;
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;

    @Inject
    public TransportDeleteCalendarEventAction(TransportService transportService, ActionFilters actionFilters, Client client, JobResultsProvider jobResultsProvider, JobManager jobManager) {
        super("cluster:admin/xpack/ml/calendars/events/delete", transportService, actionFilters, DeleteCalendarEventAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.jobResultsProvider = jobResultsProvider;
        this.jobManager = jobManager;
    }

    protected void doExecute(Task task, DeleteCalendarEventAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String eventId = request.getEventId();
        this.jobResultsProvider.calendar(request.getCalendarId(), (ActionListener<Calendar>)listener.delegateFailureAndWrap((l, calendar) -> {
            GetRequest getRequest = new GetRequest(MlMetaIndex.indexName(), eventId);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportGetAction.TYPE, (ActionRequest)getRequest, (ActionListener)l.delegateFailureAndWrap((delegate, getResponse) -> {
                if (!getResponse.isExists()) {
                    delegate.onFailure((Exception)((Object)new ResourceNotFoundException("No event with id [" + eventId + "]", new Object[0])));
                    return;
                }
                Map source = getResponse.getSourceAsMap();
                String calendarId = (String)source.get(Calendar.ID.getPreferredName());
                if (calendarId == null) {
                    delegate.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Event [" + eventId + "] does not have a valid " + Calendar.ID.getPreferredName()), (Object[])new Object[0]));
                    return;
                }
                if (!calendarId.equals(request.getCalendarId())) {
                    delegate.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Event [" + eventId + "] has " + Calendar.ID.getPreferredName() + " [" + calendarId + "] which does not match the request " + Calendar.ID.getPreferredName() + " [" + request.getCalendarId() + "]"), (Object[])new Object[0]));
                    return;
                }
                this.deleteEvent(eventId, (Calendar)calendar, (ActionListener<AcknowledgedResponse>)delegate);
            }));
        }));
    }

    private void deleteEvent(final String eventId, final Calendar calendar, final ActionListener<AcknowledgedResponse> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(MlMetaIndex.indexName(), eventId);
        deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportDeleteAction.TYPE, (ActionRequest)deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse response) {
                if (response.status() == RestStatus.NOT_FOUND) {
                    listener.onFailure((Exception)((Object)new ResourceNotFoundException("No event with id [" + eventId + "]", new Object[0])));
                } else {
                    TransportDeleteCalendarEventAction.this.jobManager.updateProcessOnCalendarChanged(calendar.getJobIds(), (ActionListener<Boolean>)listener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)AcknowledgedResponse.TRUE)));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)ExceptionsHelper.serverError((String)("Could not delete event [" + eventId + "]"), (Throwable)e));
            }
        });
    }
}

