/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;

public class MlAutoUpdateService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlAutoUpdateService.class);
    private final List<UpdateAction> updateActions;
    private final Set<String> currentlyUpdating;
    private final Set<String> completedUpdates;
    private final ThreadPool threadPool;

    public MlAutoUpdateService(ThreadPool threadPool, List<UpdateAction> updateActions) {
        this.updateActions = updateActions;
        this.completedUpdates = ConcurrentHashMap.newKeySet();
        this.currentlyUpdating = ConcurrentHashMap.newKeySet();
        this.threadPool = threadPool;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (!event.localNodeMaster()) {
            return;
        }
        TransportVersion minTransportVersion = event.state().getMinTransportVersion();
        List<UpdateAction> toRun = this.updateActions.stream().filter(action -> action.isMinTransportVersionSupported(minTransportVersion)).filter(action -> !this.completedUpdates.contains(action.getName())).filter(action -> action.isAbleToRun(event.state())).filter(action -> this.currentlyUpdating.add(action.getName())).toList();
        this.threadPool.executor("ml_utility").execute(() -> toRun.forEach(this::runUpdate));
    }

    private void runUpdate(UpdateAction action) {
        try {
            logger.debug(() -> "[" + action.getName() + "] starting executing update action");
            action.runUpdate();
            this.completedUpdates.add(action.getName());
            logger.debug(() -> "[" + action.getName() + "] succeeded executing update action");
        }
        catch (Exception ex) {
            logger.warn(() -> "[" + action.getName() + "] failure executing update action", (Throwable)ex);
        }
        finally {
            this.currentlyUpdating.remove(action.getName());
            logger.debug(() -> "[" + action.getName() + "] no longer executing update action");
        }
    }

    public static interface UpdateAction {
        public boolean isMinTransportVersionSupported(TransportVersion var1);

        public boolean isAbleToRun(ClusterState var1);

        public String getName();

        public void runUpdate();
    }
}

