/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit;

import java.io.IOException;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.repositories.blobstore.testkit.BlobAnalyzeAction;
import org.elasticsearch.repositories.blobstore.testkit.SnapshotRepositoryTestKit;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class RepositoryPerformanceSummary
implements Writeable,
ToXContentFragment {
    private final long writeCount;
    private final long writeBytes;
    private final long writeThrottledNanos;
    private final long writeElapsedNanos;
    private final long readCount;
    private final long readBytes;
    private final long readWaitNanos;
    private final long maxReadWaitNanos;
    private final long readThrottledNanos;
    private final long readElapsedNanos;

    public RepositoryPerformanceSummary(long writeCount, long writeBytes, long writeThrottledNanos, long writeElapsedNanos, long readCount, long readBytes, long readWaitNanos, long maxReadWaitNanos, long readThrottledNanos, long readElapsedNanos) {
        this.writeCount = writeCount;
        this.writeBytes = writeBytes;
        this.writeThrottledNanos = writeThrottledNanos;
        this.writeElapsedNanos = writeElapsedNanos;
        this.readCount = readCount;
        this.readBytes = readBytes;
        this.readWaitNanos = readWaitNanos;
        this.maxReadWaitNanos = maxReadWaitNanos;
        this.readThrottledNanos = readThrottledNanos;
        this.readElapsedNanos = readElapsedNanos;
    }

    public RepositoryPerformanceSummary(StreamInput in) throws IOException {
        this.writeCount = in.readVLong();
        this.writeBytes = in.readVLong();
        this.writeThrottledNanos = in.readVLong();
        this.writeElapsedNanos = in.readVLong();
        this.readCount = in.readVLong();
        this.readBytes = in.readVLong();
        this.readWaitNanos = in.readVLong();
        this.maxReadWaitNanos = in.readVLong();
        this.readThrottledNanos = in.readVLong();
        this.readElapsedNanos = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.writeCount);
        out.writeVLong(this.writeBytes);
        out.writeVLong(this.writeThrottledNanos);
        out.writeVLong(this.writeElapsedNanos);
        out.writeVLong(this.readCount);
        out.writeVLong(this.readBytes);
        out.writeVLong(this.readWaitNanos);
        out.writeVLong(this.maxReadWaitNanos);
        out.writeVLong(this.readThrottledNanos);
        out.writeVLong(this.readElapsedNanos);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("write");
        builder.field("count", this.writeCount);
        builder.humanReadableField("total_size_bytes", "total_size", (Object)ByteSizeValue.ofBytes((long)this.writeBytes));
        SnapshotRepositoryTestKit.humanReadableNanos(builder, "total_throttled_nanos", "total_throttled", this.writeThrottledNanos);
        SnapshotRepositoryTestKit.humanReadableNanos(builder, "total_elapsed_nanos", "total_elapsed", this.writeElapsedNanos);
        builder.endObject();
        builder.startObject("read");
        builder.field("count", this.readCount);
        builder.humanReadableField("total_size_bytes", "total_size", (Object)ByteSizeValue.ofBytes((long)this.readBytes));
        SnapshotRepositoryTestKit.humanReadableNanos(builder, "total_wait_nanos", "total_wait", this.readWaitNanos);
        SnapshotRepositoryTestKit.humanReadableNanos(builder, "max_wait_nanos", "max_wait", this.maxReadWaitNanos);
        SnapshotRepositoryTestKit.humanReadableNanos(builder, "total_throttled_nanos", "total_throttled", this.readThrottledNanos);
        SnapshotRepositoryTestKit.humanReadableNanos(builder, "total_elapsed_nanos", "total_elapsed", this.readElapsedNanos);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    static class Builder {
        private final LongAdder writeCount = new LongAdder();
        private final LongAdder writeBytes = new LongAdder();
        private final LongAdder writeThrottledNanos = new LongAdder();
        private final LongAdder writeElapsedNanos = new LongAdder();
        private final LongAdder readCount = new LongAdder();
        private final LongAdder readBytes = new LongAdder();
        private final LongAdder readWaitNanos = new LongAdder();
        private final LongAccumulator maxReadWaitNanos = new LongAccumulator(Long::max, Long.MIN_VALUE);
        private final LongAdder readThrottledNanos = new LongAdder();
        private final LongAdder readElapsedNanos = new LongAdder();

        Builder() {
        }

        public RepositoryPerformanceSummary build() {
            return new RepositoryPerformanceSummary(this.writeCount.longValue(), this.writeBytes.longValue(), this.writeThrottledNanos.longValue(), this.writeElapsedNanos.longValue(), this.readCount.longValue(), this.readBytes.longValue(), this.readWaitNanos.longValue(), Long.max(0L, this.maxReadWaitNanos.longValue()), this.readThrottledNanos.longValue(), this.readElapsedNanos.longValue());
        }

        public void add(BlobAnalyzeAction.Response response) {
            this.writeCount.add(1L);
            this.writeBytes.add(response.getWriteBytes());
            this.writeThrottledNanos.add(response.getWriteThrottledNanos());
            this.writeElapsedNanos.add(response.getWriteElapsedNanos());
            long checksumBytes = response.getChecksumBytes();
            for (BlobAnalyzeAction.ReadDetail readDetail : response.getReadDetails()) {
                this.readCount.add(1L);
                this.readBytes.add(checksumBytes);
                this.readWaitNanos.add(readDetail.getFirstByteNanos());
                this.maxReadWaitNanos.accumulate(readDetail.getFirstByteNanos());
                this.readThrottledNanos.add(readDetail.getThrottledNanos());
                this.readElapsedNanos.add(readDetail.getElapsedNanos());
            }
        }
    }
}

