/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.Arrays;
import java.util.function.Predicate;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;

public interface StructureAnyD
extends Structure1D {
    public static int count(int[] structure) {
        int retVal = 1;
        int tmpLength = structure.length;
        for (int i = 0; i < tmpLength; ++i) {
            retVal *= structure[i];
        }
        return retVal;
    }

    public static int count(int[] structure, int dimension) {
        return structure.length > dimension ? structure[dimension] : 1;
    }

    public static long count(long[] structure) {
        long retVal = 1L;
        int tmpLength = structure.length;
        for (int i = 0; i < tmpLength; ++i) {
            retVal *= structure[i];
        }
        return retVal;
    }

    public static long count(long[] structure, int dimension) {
        return structure.length > dimension ? structure[dimension] : 1L;
    }

    public static int index(int[] structure, int[] reference) {
        int retVal = reference[0];
        int tmpFactor = structure[0];
        int tmpLength = reference.length;
        for (int i = 1; i < tmpLength; ++i) {
            retVal += tmpFactor * reference[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static long index(long[] structure, long[] reference) {
        long retVal = reference[0];
        long tmpFactor = structure[0];
        int tmpLength = Math.min(structure.length, reference.length);
        for (int i = 1; i < tmpLength; ++i) {
            retVal += tmpFactor * reference[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static void loopMatching(StructureAnyD structureA, StructureAnyD structureB, Structure1D.IndexCallback callback) {
        if (!Arrays.equals(structureA.shape(), structureB.shape())) {
            throw new ProgrammingError("The 2 structures must have the same shape!");
        }
        Structure1D.loopMatching(structureA, structureB, callback);
    }

    public static ReferenceMapper mapperOf(StructureAnyD structure, Structure1D.IndexMapper<Object>[] mappers) {
        return new ReferenceMapper(structure, mappers);
    }

    public static long[] reference(long index, long[] structure) {
        long[] retVal = new long[structure.length];
        long tmpPrev = 1L;
        long tmpNext = 1L;
        for (int s = 0; s < structure.length; ++s) {
            retVal[s] = index % (tmpNext *= structure[s]) / tmpPrev;
            tmpPrev = tmpNext;
        }
        return retVal;
    }

    public static long[] shape(StructureAnyD structure) {
        long tmpSize = structure.count();
        long tmpTotal = structure.count(0);
        int tmpRank = 1;
        while (tmpTotal < tmpSize) {
            tmpTotal *= structure.count(tmpRank);
            ++tmpRank;
        }
        long[] retVal = new long[tmpRank];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = structure.count(i);
        }
        return retVal;
    }

    public static int step(int[] structure, int dimension) {
        int retVal = 1;
        for (int i = 0; i < dimension; ++i) {
            retVal *= StructureAnyD.count(structure, i);
        }
        return retVal;
    }

    public static int step(int[] structure, int[] increment) {
        int retVal = 0;
        int tmpFactor = 1;
        int tmpLimit = increment.length;
        for (int i = 1; i < tmpLimit; ++i) {
            retVal += tmpFactor * increment[i];
            tmpFactor *= structure[i];
        }
        return retVal;
    }

    public static long step(long[] structure, int dimension) {
        long retVal = 1L;
        for (int i = 0; i < dimension; ++i) {
            retVal *= StructureAnyD.count(structure, i);
        }
        return retVal;
    }

    public static long step(long[] structure, long[] increment) {
        long retVal = 0L;
        long factor = 1L;
        int limit = increment.length;
        for (int i = 1; i < limit; ++i) {
            retVal += factor * increment[i];
            factor *= structure[i];
        }
        return retVal;
    }

    @Override
    default public long count() {
        return StructureAnyD.count(this.shape());
    }

    public long count(int var1);

    default public void loop(int dimension, long dimensionalIndex, Structure1D.LoopCallback callback) {
        long[] structure = this.shape();
        long innerCount = 1L;
        long dimenCount = 1L;
        long outerCount = 1L;
        for (int i = 0; i < structure.length; ++i) {
            if (i < dimension) {
                innerCount *= structure[i];
                continue;
            }
            if (i > dimension) {
                outerCount *= structure[i];
                continue;
            }
            dimenCount = structure[i];
        }
        long totalCount = innerCount * dimenCount * outerCount;
        if (innerCount == 1L) {
            callback.call(dimensionalIndex * innerCount, totalCount, dimenCount);
        } else {
            long step = innerCount * dimenCount;
            for (long i = dimensionalIndex * innerCount; i < totalCount; i += step) {
                callback.call(i, innerCount + i, 1L);
            }
        }
    }

    default public void loop(long[] initial, int dimension, Structure1D.LoopCallback callback) {
        long[] structure = this.shape();
        long remaining = StructureAnyD.count(structure, dimension) - initial[dimension];
        long first = StructureAnyD.index(structure, initial);
        long step = StructureAnyD.step(structure, dimension);
        long limit = first + step * remaining;
        callback.call(first, limit, step);
    }

    default public void loop(Predicate<long[]> filter, Structure1D.IndexCallback callback) {
        long[] structure = this.shape();
        long limit = this.count();
        for (long i = 0L; i < limit; ++i) {
            long[] reference = StructureAnyD.reference(i, structure);
            if (!filter.test(reference)) continue;
            callback.call(i);
        }
    }

    default public void loopAll(ReferenceCallback callback) {
        long[] shape = this.shape();
        for (long i = 0L; i < this.count(); ++i) {
            callback.call(StructureAnyD.reference(i, shape));
        }
    }

    default public int rank() {
        return this.shape().length;
    }

    public long[] shape();

    public static interface Reshapable
    extends StructureAnyD {
        public StructureAnyD expand(int var1);

        public Structure1D flatten();

        public StructureAnyD reshape(long ... var1);

        public StructureAnyD squeeze();
    }

    public static class ReferenceMapper
    implements Structure1D.IndexMapper<Object[]> {
        private final Structure1D.IndexMapper<Object>[] myMappers;
        private final long[] myStructure;

        protected ReferenceMapper(StructureAnyD structure, Structure1D.IndexMapper<Object>[] mappers) {
            this.myMappers = mappers;
            this.myStructure = structure.shape();
        }

        public <T> long toIndex(int dim, T key) {
            return this.myMappers[dim].toIndex(key);
        }

        @Override
        public long toIndex(Object[] keys) {
            long[] ref = new long[keys.length];
            for (int i = 0; i < ref.length; ++i) {
                ref[i] = this.myMappers[i].toIndex(keys[i]);
            }
            return StructureAnyD.index(this.myStructure, ref);
        }

        public <T> T toKey(int dim, long index) {
            return (T)this.myMappers[dim].toKey(index);
        }

        @Override
        public Object[] toKey(long index) {
            long[] ref = StructureAnyD.reference(index, this.myStructure);
            Object[] retVal = new Object[ref.length];
            for (int i = 0; i < ref.length; ++i) {
                retVal[i] = this.myMappers[i].toKey(ref[i]);
            }
            return retVal;
        }

        public <T extends Comparable<? super T>> T toKey(long index, int dim) {
            long[] ref = StructureAnyD.reference(index, this.myStructure);
            return (T)((Comparable)this.myMappers[dim].toKey(ref[dim]));
        }
    }

    @FunctionalInterface
    public static interface ReferenceCallback {
        public void call(long[] var1);
    }

    public static interface ReducibleTo2D<R extends Structure2D>
    extends StructureAnyD {
        public R reduce(int var1, int var2, Aggregator var3);
    }

    public static interface ReducibleTo1D<R extends Structure1D>
    extends StructureAnyD {
        public R reduce(int var1, Aggregator var2);
    }

    public static final class LongReference
    implements Comparable<LongReference> {
        public final long[] reference;

        public static LongReference of(long ... aReference) {
            return new LongReference(aReference);
        }

        public LongReference(long ... aReference) {
            this.reference = aReference;
        }

        private LongReference() {
            this(-1L);
        }

        @Override
        public int compareTo(LongReference ref) {
            int retVal = Integer.compare(this.reference.length, ref.reference.length);
            for (int i = this.reference.length - 1; retVal == 0 && i >= 0; --i) {
                retVal = Long.compare(this.reference[i], ref.reference[i]);
            }
            return retVal;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof LongReference)) {
                return false;
            }
            LongReference other = (LongReference)obj;
            return Arrays.equals(this.reference, other.reference);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.reference);
            return result;
        }

        public String toString() {
            return Arrays.toString(this.reference);
        }
    }

    public static interface Logical<S extends StructureAnyD, B extends Logical<S, B>>
    extends StructureAnyD {
    }

    public static final class IntReference
    implements Comparable<IntReference> {
        public final int[] reference;

        public static IntReference of(int ... aReference) {
            return new IntReference(aReference);
        }

        public IntReference(int ... aReference) {
            this.reference = aReference;
        }

        private IntReference() {
            this(-1);
        }

        @Override
        public int compareTo(IntReference ref) {
            int retVal = this.reference.length - ref.reference.length;
            for (int i = this.reference.length - 1; retVal == 0 && i >= 0; --i) {
                retVal = this.reference[i] - ref.reference[i];
            }
            return retVal;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof IntReference)) {
                return false;
            }
            IntReference other = (IntReference)obj;
            return Arrays.equals(this.reference, other.reference);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.reference);
            return result;
        }

        public String toString() {
            return Arrays.toString(this.reference);
        }
    }
}

