/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.ComposingStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

final class SuperimposedStore<N extends Comparable<N>>
extends ComposingStore<N> {
    private final int myColFirst;
    private final int myColLimit;
    private final MatrixStore<N> myDiff;
    private final int myRowFirst;
    private final int myRowLimit;

    SuperimposedStore(MatrixStore<N> base, long row, long col, MatrixStore<N> diff) {
        super(base, base.countRows(), base.countColumns());
        this.myRowFirst = Math.toIntExact(row);
        this.myColFirst = Math.toIntExact(col);
        long diffRowDim = diff.countRows();
        long diffColDim = diff.countColumns();
        this.myRowLimit = Math.toIntExact(row + diffRowDim);
        this.myColLimit = Math.toIntExact(col + diffColDim);
        this.myDiff = diff;
    }

    SuperimposedStore(MatrixStore<N> base, MatrixStore<N> diff) {
        this(base, 0L, 0L, diff);
    }

    @Override
    public double doubleValue(long row, long col) {
        double retVal = this.base().doubleValue(row, col);
        if (this.isCovered(row, col)) {
            retVal += this.myDiff.doubleValue(row - (long)this.myRowFirst, col - (long)this.myColFirst);
        }
        return retVal;
    }

    @Override
    public N get(long row, long col) {
        Object retVal = this.base().get(row, col);
        if (this.isCovered(row, col)) {
            retVal = (Comparable)((Scalar)this.myDiff.toScalar((int)row - this.myRowFirst, (int)col - this.myColFirst).add(retVal)).get();
        }
        return retVal;
    }

    @Override
    public void multiply(Access1D<N> right, TransformableRegion<N> target) {
        super.multiply(right, target);
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        return super.multiply(scalar);
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        return super.multiply(right);
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        return super.multiply((Comparable)scalar);
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return super.premultiply(left);
    }

    @Override
    public void supplyTo(TransformableRegion<N> consumer) {
        consumer.fillMatching(this.base());
        consumer.regionByLimits(this.myRowLimit, this.myColLimit).regionByOffsets(this.myRowFirst, this.myColFirst).modifyMatching(this.physical().function().add(), this.myDiff);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        Scalar retVal = this.base().toScalar(row, column);
        if (this.isCovered(row, column)) {
            retVal = (Scalar)retVal.add(this.myDiff.get(row - (long)this.myRowFirst, column - (long)this.myColFirst));
        }
        return retVal;
    }

    private boolean isCovered(int row, int col) {
        return this.myRowFirst <= row && this.myColFirst <= col && row < this.myRowLimit && col < this.myColLimit;
    }

    private boolean isCovered(long row, long col) {
        return this.isCovered(Math.toIntExact(row), Math.toIntExact(col));
    }
}

