/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Supplier;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.tensor.TensorFactory1D;
import org.ojalgo.tensor.TensorFactory2D;

public abstract class MatrixFactory<N extends Comparable<N>, M extends BasicMatrix<N, M>, DR extends Mutate2D.ModifiableReceiver<N> & Supplier<M>, SR extends Mutate2D.ModifiableReceiver<N> & Supplier<M>>
implements Factory2D.Dense<M>,
Factory2D.MayBeSparse<M, DR, SR> {
    private final Constructor<M> myConstructor;
    private final PhysicalStore.Factory<N, ?> myPhysicalFactory;

    private static Constructor<? extends BasicMatrix<?, ?>> getConstructor(Class<? extends BasicMatrix<?, ?>> template) {
        try {
            Constructor<BasicMatrix<?, ?>> retVal = template.getDeclaredConstructor(ElementsSupplier.class);
            retVal.setAccessible(true);
            return retVal;
        }
        catch (NoSuchMethodException | SecurityException cause) {
            throw new ProgrammingError(cause);
        }
    }

    MatrixFactory(Class<M> template, PhysicalStore.Factory<N, ?> factory) {
        this.myPhysicalFactory = factory;
        this.myConstructor = MatrixFactory.getConstructor(template);
    }

    @Override
    public M columns(Access1D<?> ... source) {
        return this.instantiate((ElementsSupplier)this.myPhysicalFactory.columns(source));
    }

    @Override
    public M columns(Comparable<?>[] ... source) {
        return this.instantiate((ElementsSupplier)this.myPhysicalFactory.columns(source));
    }

    @Override
    public M columns(double[] ... source) {
        return this.instantiate((ElementsSupplier)this.myPhysicalFactory.columns(source));
    }

    @Override
    public M columns(List<? extends Comparable<?>> ... source) {
        return this.instantiate((ElementsSupplier)this.myPhysicalFactory.columns(source));
    }

    @Override
    public M copy(Access2D<?> source) {
        return this.instantiate((ElementsSupplier)this.myPhysicalFactory.copy(source));
    }

    public FunctionSet<N> function() {
        return this.myPhysicalFactory.function();
    }

    @Override
    public M make(long rows, long columns) {
        return this.instantiate(this.myPhysicalFactory.makeZero((int)rows, (int)columns));
    }

    public DR makeDense(int count) {
        return this.makeDense(count, 1L);
    }

    @Override
    public DR makeDense(long rows, long columns) {
        return this.dense((PhysicalStore)this.myPhysicalFactory.make(rows, columns));
    }

    public M makeDiagonal(Access1D<?> diagonal) {
        return this.instantiate((ElementsSupplier<N>)this.myPhysicalFactory.makeDiagonal(diagonal).get());
    }

    public M makeDiagonal(double ... diagonal) {
        return this.makeDiagonal(Primitive64Array.wrap(diagonal));
    }

    public M makeEye(int rows, int columns) {
        int square = Math.min(rows, columns);
        Structure2D.Logical retVal = this.myPhysicalFactory.makeIdentity(square);
        if (rows > square) {
            retVal = retVal.below(rows - square);
        } else if (columns > square) {
            retVal = retVal.right(columns - square);
        }
        return this.instantiate((ElementsSupplier<N>)((Object)retVal));
    }

    public M makeEye(Structure2D shape) {
        return this.makeEye(Math.toIntExact(shape.countRows()), Math.toIntExact(shape.countColumns()));
    }

    @Override
    public M makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
        return this.instantiate((ElementsSupplier<N>)this.myPhysicalFactory.makeFilled(rows, columns, (NullaryFunction)supplier));
    }

    public M makeIdentity(int dimension) {
        return this.instantiate(this.myPhysicalFactory.makeIdentity(dimension));
    }

    public M makeSingle(N element) {
        return this.instantiate(this.myPhysicalFactory.makeSingle(element));
    }

    @Override
    public SR makeSparse(long rows, long columns) {
        return this.sparse((SparseStore<N>)this.myPhysicalFactory.makeSparse(rows, columns));
    }

    @Override
    public SR makeSparse(Structure2D shape) {
        return (SR)this.makeSparse(Math.toIntExact(shape.countRows()), Math.toIntExact(shape.countColumns()));
    }

    public M makeWrapper(Access2D<?> elements) {
        return this.instantiate(this.myPhysicalFactory.makeWrapper(elements));
    }

    @Override
    public M rows(Access1D<?> ... source) {
        return this.instantiate((ElementsSupplier)this.myPhysicalFactory.rows(source));
    }

    @Override
    public M rows(Comparable<?>[] ... source) {
        return this.instantiate((ElementsSupplier)this.myPhysicalFactory.rows(source));
    }

    @Override
    public M rows(double[] ... source) {
        return this.instantiate((ElementsSupplier)this.myPhysicalFactory.rows(source));
    }

    @Override
    public M rows(List<? extends Comparable<?>> ... source) {
        return this.instantiate((ElementsSupplier)this.myPhysicalFactory.rows(source));
    }

    public Scalar.Factory<N> scalar() {
        return this.myPhysicalFactory.scalar();
    }

    public TensorFactory1D<N, DR> tensor1D() {
        return TensorFactory1D.of(new Factory1D<DR>(){

            public FunctionSet<N> function() {
                return MatrixFactory.this.function();
            }

            @Override
            public DR make(long count) {
                return MatrixFactory.this.makeDense(count, 1L);
            }

            public Scalar.Factory<N> scalar() {
                return MatrixFactory.this.scalar();
            }
        });
    }

    public TensorFactory2D<N, DR> tensor2D() {
        return TensorFactory2D.of(new Factory2D<DR>(){

            public FunctionSet<N> function() {
                return MatrixFactory.this.function();
            }

            @Override
            public DR make(long rows, long columns) {
                return MatrixFactory.this.makeDense(rows, columns);
            }

            public Scalar.Factory<N> scalar() {
                return MatrixFactory.this.scalar();
            }
        });
    }

    abstract DR dense(PhysicalStore<N> var1);

    final PhysicalStore.Factory<N, ?> getPhysicalFactory() {
        return this.myPhysicalFactory;
    }

    M instantiate(ElementsSupplier<N> supplier) {
        try {
            return (M)((BasicMatrix)this.myConstructor.newInstance(supplier));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException cause) {
            throw new ProgrammingError(cause);
        }
    }

    abstract SR sparse(SparseStore<N> var1);
}

