/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.io.Reader;
import org.ojalgo.data.domain.finance.series.DataFetcher;
import org.ojalgo.netio.ResourceLocator;
import org.ojalgo.type.CalendarDateUnit;

public class AlphaVantageFetcher
implements DataFetcher {
    private final CalendarDateUnit myResolution;
    private final ResourceLocator myResourceLocator;
    private final String mySymbol;

    public AlphaVantageFetcher(String symbol, CalendarDateUnit resolution, String apiKey, boolean fullOutputSize) {
        this.mySymbol = symbol;
        this.myResolution = resolution;
        this.myResourceLocator = new ResourceLocator().host("www.alphavantage.co").path("/query");
        switch (resolution) {
            case MONTH: {
                this.myResourceLocator.query("function", "TIME_SERIES_MONTHLY_ADJUSTED");
                break;
            }
            case WEEK: {
                this.myResourceLocator.query("function", "TIME_SERIES_WEEKLY_ADJUSTED");
                break;
            }
            default: {
                this.myResourceLocator.query("function", "TIME_SERIES_DAILY_ADJUSTED");
            }
        }
        this.myResourceLocator.query("symbol", symbol);
        this.myResourceLocator.query("apikey", apiKey);
        this.myResourceLocator.query("datatype", "csv");
        if (fullOutputSize && resolution == CalendarDateUnit.DAY && !"demo".equals(apiKey)) {
            this.myResourceLocator.query("outputsize", "full");
        }
    }

    @Override
    public CalendarDateUnit getResolution() {
        return this.myResolution;
    }

    @Override
    public Reader getStreamOfCSV() {
        return this.myResourceLocator.getStreamReader();
    }

    @Override
    public String getSymbol() {
        return this.mySymbol;
    }
}

