/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import org.ojalgo.concurrent.DaemonPoolExecutor;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.concurrent.Parallelism;

public final class ProcessingService {
    public static final ProcessingService INSTANCE = new ProcessingService(DaemonPoolExecutor.INSTANCE);
    private final ExecutorService myExecutor;

    public static ProcessingService newInstance(String name) {
        return new ProcessingService(DaemonPoolExecutor.newCachedThreadPool(name));
    }

    public ProcessingService(ExecutorService executor) {
        this.myExecutor = executor;
    }

    public <W, R> Map<W, R> compute(Collection<W> work, Function<W, R> processor) {
        return this.compute(work, Parallelism.CORES, processor);
    }

    public <W, R> Map<W, R> compute(Collection<W> work, IntSupplier parallelism, Function<W, R> processor) {
        int load = work.size();
        int concurrency = Math.min(load, parallelism.getAsInt());
        LinkedBlockingDeque<W> queue = new LinkedBlockingDeque<W>(work);
        ConcurrentHashMap results = new ConcurrentHashMap(load);
        ArrayList<CallableFunction<W, R>> tasks = new ArrayList<CallableFunction<W, R>>(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            tasks.add(new CallableFunction<W, R>(queue, processor, results));
        }
        try {
            for (Future future : this.myExecutor.invokeAll(tasks)) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException cause) {
            throw new RuntimeException(cause);
        }
        return results;
    }

    public <W, R> Map<W, R> computePair(W work1, W work2, Function<W, R> processor) {
        return this.compute(Arrays.asList(work1, work2), processor);
    }

    public <W, R> Map<W, R> computeTriplet(W work1, W work2, W work3, Function<W, R> processor) {
        return this.compute(Arrays.asList(work1, work2, work3), processor);
    }

    public DivideAndConquer.Divider divider() {
        return new DivideAndConquer.Divider(this.myExecutor);
    }

    public ExecutorService getExecutor() {
        return this.myExecutor;
    }

    public <W> void process(Collection<? extends W> work, Consumer<W> processor) {
        this.process(work, Parallelism.CORES, processor);
    }

    public <W> void process(Collection<? extends W> work, IntSupplier parallelism, Consumer<W> processor) {
        int load = work.size();
        int concurrency = Math.min(load, parallelism.getAsInt());
        LinkedBlockingDeque<? extends W> queue = new LinkedBlockingDeque<W>(work);
        ArrayList<CallableConsumer<? extends W>> tasks = new ArrayList<CallableConsumer<? extends W>>(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            tasks.add(new CallableConsumer<W>(queue, processor));
        }
        try {
            for (Future future : this.myExecutor.invokeAll(tasks)) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException cause) {
            throw new RuntimeException(cause);
        }
    }

    public <W> void processPair(W work1, W work2, Consumer<W> processor) {
        this.process(Arrays.asList(work1, work2), processor);
    }

    public <W> void processTriplet(W work1, W work2, W work3, Consumer<W> processor) {
        this.process(Arrays.asList(work1, work2, work3), processor);
    }

    public void run(IntSupplier parallelism, Runnable processor) {
        int concurrency = parallelism.getAsInt();
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(concurrency);
        for (int i = 0; i < concurrency; ++i) {
            tasks.add(Executors.callable(processor));
        }
        try {
            for (Future future : this.myExecutor.invokeAll(tasks)) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException cause) {
            throw new RuntimeException(cause);
        }
    }

    static final class CallableFunction<W, R>
    implements Callable<Map<W, R>> {
        private final Function<W, R> myFunction;
        private final Map<W, R> myResults;
        private final Queue<W> myWork;

        CallableFunction(Queue<W> work, Function<W, R> function, Map<W, R> results) {
            this.myWork = work;
            this.myFunction = function;
            this.myResults = results;
        }

        @Override
        public Map<W, R> call() throws Exception {
            Object item = null;
            while (true) {
                W w = this.myWork.poll();
                item = w;
                if (w == null) break;
                this.myResults.computeIfAbsent(item, k -> this.myFunction.apply(k));
            }
            return this.myResults;
        }
    }

    static final class CallableConsumer<W>
    implements Callable<Boolean> {
        private final Consumer<W> myConsumer;
        private final Queue<W> myWork;

        CallableConsumer(Queue<W> work, Consumer<W> consumer) {
            this.myWork = work;
            this.myConsumer = consumer;
        }

        @Override
        public Boolean call() throws Exception {
            Object item = null;
            while (true) {
                W w = this.myWork.poll();
                item = w;
                if (w == null) break;
                this.myConsumer.accept(item);
            }
            return Boolean.TRUE;
        }
    }
}

