/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceRateLimitServiceSettings;

public class HuggingFaceServiceSettings
implements ServiceSettings,
HuggingFaceRateLimitServiceSettings {
    public static final String NAME = "hugging_face_service_settings";
    private final URI uri;
    private final SimilarityMeasure similarity;
    private final Integer dimensions;
    private final Integer maxInputTokens;

    public static HuggingFaceServiceSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        URI uri = HuggingFaceServiceSettings.extractUri(map, "url", validationException);
        SimilarityMeasure similarityMeasure = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new HuggingFaceServiceSettings(uri, similarityMeasure, dims, maxInputTokens);
    }

    public static URI extractUri(Map<String, Object> map, String fieldName, ValidationException validationException) {
        String parsedUrl = ServiceUtils.extractRequiredString(map, fieldName, "service_settings", validationException);
        return ServiceUtils.convertToUri(parsedUrl, fieldName, "service_settings", validationException);
    }

    public HuggingFaceServiceSettings(URI uri) {
        this.uri = Objects.requireNonNull(uri);
        this.similarity = null;
        this.dimensions = null;
        this.maxInputTokens = null;
    }

    public HuggingFaceServiceSettings(URI uri, @Nullable SimilarityMeasure similarityMeasure, @Nullable Integer dimensions, @Nullable Integer maxInputTokens) {
        this.uri = Objects.requireNonNull(uri);
        this.similarity = similarityMeasure;
        this.dimensions = dimensions;
        this.maxInputTokens = maxInputTokens;
    }

    public HuggingFaceServiceSettings(String url) {
        this(ServiceUtils.createUri(url));
    }

    public HuggingFaceServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createUri(in.readString());
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
            this.dimensions = in.readOptionalVInt();
            this.maxInputTokens = in.readOptionalVInt();
        } else {
            this.similarity = null;
            this.dimensions = null;
            this.maxInputTokens = null;
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("url", this.uri.toString());
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        builder.endObject();
        return builder;
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uri.toString());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
            out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
            out.writeOptionalVInt(this.dimensions);
            out.writeOptionalVInt(this.maxInputTokens);
        }
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HuggingFaceServiceSettings that = (HuggingFaceServiceSettings)o;
        return Objects.equals(this.uri, that.uri) && this.similarity == that.similarity && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.similarity, this.dimensions, this.maxInputTokens);
    }
}

