/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elser;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elser.ElserInternalService;
import org.elasticsearch.xpack.inference.services.settings.InternalServiceSettings;

public class ElserInternalServiceSettings
extends InternalServiceSettings {
    public static final String NAME = "elser_mlnode_service_settings";

    public static InternalServiceSettings.Builder fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Integer numAllocations = ServiceUtils.removeAsType(map, "num_allocations", Integer.class);
        Integer numThreads = ServiceUtils.removeAsType(map, "num_threads", Integer.class);
        ElserInternalServiceSettings.validateParameters(numAllocations, validationException, numThreads);
        String model_id = ServiceUtils.removeAsType(map, "model_id", String.class);
        if (model_id != null && !ElserInternalService.VALID_ELSER_MODEL_IDS.contains(model_id)) {
            validationException.addValidationError("unknown ELSER model id [" + model_id + "]");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        InternalServiceSettings.Builder builder = new InternalServiceSettings.Builder(){

            @Override
            public ElserInternalServiceSettings build() {
                return new ElserInternalServiceSettings(this.getNumAllocations(), this.getNumThreads(), this.getModelId());
            }
        };
        builder.setNumAllocations(numAllocations);
        builder.setNumThreads(numThreads);
        builder.setModelId(model_id);
        return builder;
    }

    public ElserInternalServiceSettings(int numAllocations, int numThreads, String modelId) {
        super(numAllocations, numThreads, modelId);
        Objects.requireNonNull(modelId);
    }

    public ElserInternalServiceSettings(StreamInput in) throws IOException {
        super(in.readVInt(), in.readVInt(), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_11_X) ? in.readString() : ".elser_model_2");
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_11_X;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.getNumAllocations());
        out.writeVInt(this.getNumThreads());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_11_X)) {
            out.writeString(this.getModelId());
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(NAME, this.getNumAllocations(), this.getNumThreads(), this.getModelId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElserInternalServiceSettings that = (ElserInternalServiceSettings)o;
        return this.getNumAllocations() == that.getNumAllocations() && this.getNumThreads() == that.getNumThreads() && Objects.equals(this.getModelId(), that.getModelId());
    }
}

