/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AllocationStatus;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchModel;

public class CustomElandModel
extends ElasticsearchModel {
    public CustomElandModel(String inferenceEntityId, TaskType taskType, String service, CustomElandInternalServiceSettings serviceSettings) {
        super(inferenceEntityId, taskType, service, serviceSettings);
    }

    @Override
    public CustomElandInternalServiceSettings getServiceSettings() {
        return (CustomElandInternalServiceSettings)super.getServiceSettings();
    }

    @Override
    StartTrainedModelDeploymentAction.Request getStartTrainedModelDeploymentActionRequest() {
        StartTrainedModelDeploymentAction.Request startRequest = new StartTrainedModelDeploymentAction.Request(this.getServiceSettings().getModelId(), this.getInferenceEntityId());
        startRequest.setNumberOfAllocations(this.getServiceSettings().getNumAllocations());
        startRequest.setThreadsPerAllocation(this.getServiceSettings().getNumThreads());
        startRequest.setWaitForState(AllocationStatus.State.STARTED);
        return startRequest;
    }

    @Override
    ActionListener<CreateTrainedModelAssignmentAction.Response> getCreateTrainedModelAssignmentActionListener(Model model, final ActionListener<Boolean> listener) {
        return new ActionListener<CreateTrainedModelAssignmentAction.Response>(){

            public void onResponse(CreateTrainedModelAssignmentAction.Response response) {
                listener.onResponse((Object)Boolean.TRUE);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not start the TextEmbeddingService service as the custom eland model [{0}] for this platform cannot be found. Custom models need to be loaded into the cluster with eland before they can be started.", new Object[]{CustomElandModel.this.getServiceSettings().getModelId()}));
                    return;
                }
                listener.onFailure(e);
            }
        };
    }
}

