/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.InternalServiceSettings;

public class CustomElandInternalServiceSettings
extends ElasticsearchInternalServiceSettings {
    public static final String NAME = "custom_eland_model_internal_service_settings";

    public CustomElandInternalServiceSettings(int numAllocations, int numThreads, String modelId) {
        super(numAllocations, numThreads, modelId);
    }

    public static InternalServiceSettings.Builder fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Integer numAllocations = ServiceUtils.removeAsType(map, "num_allocations", Integer.class);
        Integer numThreads = ServiceUtils.removeAsType(map, "num_threads", Integer.class);
        CustomElandInternalServiceSettings.validateParameters(numAllocations, validationException, numThreads);
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "ServiceSettings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        InternalServiceSettings.Builder builder = new InternalServiceSettings.Builder(){

            @Override
            public CustomElandInternalServiceSettings build() {
                return new CustomElandInternalServiceSettings(this.getNumAllocations(), this.getNumThreads(), this.getModelId());
            }
        };
        builder.setNumAllocations(numAllocations);
        builder.setNumThreads(numThreads);
        builder.setModelId(modelId);
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return super.toXContent(builder, params);
    }

    public CustomElandInternalServiceSettings(StreamInput in) throws IOException {
        super(in.readVInt(), in.readVInt(), in.readString());
    }

    @Override
    public boolean isFragment() {
        return super.isFragment();
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_TEXT_EMBEDDING_INFERENCE_SERVICE_ADDED;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }
}

