/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.rerank;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.cohere.CohereServiceSettings;

public class CohereRerankServiceSettings
implements ServiceSettings {
    public static final String NAME = "cohere_rerank_service_settings";
    private final CohereServiceSettings commonSettings;

    public static CohereRerankServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext parseContext) {
        ValidationException validationException = new ValidationException();
        CohereServiceSettings commonServiceSettings = CohereServiceSettings.fromMap(map, parseContext);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CohereRerankServiceSettings(commonServiceSettings);
    }

    public CohereRerankServiceSettings(CohereServiceSettings commonSettings) {
        this.commonSettings = commonSettings;
    }

    public CohereRerankServiceSettings(StreamInput in) throws IOException {
        this.commonSettings = new CohereServiceSettings(in);
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.commonSettings.toXContentFragment(builder);
        builder.endObject();
        return builder;
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_COHERE_RERANK;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.commonSettings.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CohereRerankServiceSettings that = (CohereRerankServiceSettings)o;
        return Objects.equals(this.commonSettings, that.commonSettings);
    }

    public int hashCode() {
        return Objects.hash(this.commonSettings);
    }

    public CohereServiceSettings getCommonSettings() {
        return this.commonSettings;
    }
}

