/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class CohereServiceSettings
implements ServiceSettings {
    private static final Logger logger = LogManager.getLogger(CohereServiceSettings.class);
    public static final String NAME = "cohere_service_settings";
    public static final String OLD_MODEL_ID_FIELD = "model";
    public static final String MODEL_ID = "model_id";
    private final URI uri;
    private final SimilarityMeasure similarity;
    private final Integer dimensions;
    private final Integer maxInputTokens;
    private final String modelId;

    public static CohereServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        String oldModelId = ServiceUtils.extractOptionalString(map, OLD_MODEL_ID_FIELD, "service_settings", validationException);
        String modelId = ServiceUtils.extractOptionalString(map, MODEL_ID, "service_settings", validationException);
        if (context == ConfigurationParseContext.REQUEST && oldModelId != null) {
            logger.info("The cohere [service_settings.model] field is deprecated. Please use [service_settings.model_id] instead.");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CohereServiceSettings(uri, similarity, dims, maxInputTokens, CohereServiceSettings.modelId(oldModelId, modelId));
    }

    private static String modelId(@Nullable String model, @Nullable String modelId) {
        return modelId != null ? modelId : model;
    }

    public CohereServiceSettings(@Nullable URI uri, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, @Nullable String modelId) {
        this.uri = uri;
        this.similarity = similarity;
        this.dimensions = dimensions;
        this.maxInputTokens = maxInputTokens;
        this.modelId = modelId;
    }

    public CohereServiceSettings(@Nullable String url, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, @Nullable String modelId) {
        this(ServiceUtils.createOptionalUri(url), similarity, dimensions, maxInputTokens, modelId);
    }

    public CohereServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createOptionalUri(in.readOptionalString());
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.dimensions = in.readOptionalVInt();
        this.maxInputTokens = in.readOptionalVInt();
        this.modelId = in.readOptionalString();
    }

    public URI uri() {
        return this.uri;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public String modelId() {
        return this.modelId;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder) throws IOException {
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        if (this.modelId != null) {
            builder.field(MODEL_ID, this.modelId);
        }
        return builder;
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_COHERE_EMBEDDINGS_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        String uriToWrite = this.uri != null ? this.uri.toString() : null;
        out.writeOptionalString(uriToWrite);
        out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
        out.writeOptionalVInt(this.dimensions);
        out.writeOptionalVInt(this.maxInputTokens);
        out.writeOptionalString(this.modelId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CohereServiceSettings that = (CohereServiceSettings)o;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.modelId, that.modelId);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.similarity, this.dimensions, this.maxInputTokens, this.modelId);
    }
}

