/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsRequestTaskSettings;

public class AzureOpenAiEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "azure_openai_embeddings_task_settings";
    private final String user;

    public static AzureOpenAiEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        String user = ServiceUtils.extractOptionalString(map, "user", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureOpenAiEmbeddingsTaskSettings(user);
    }

    public static AzureOpenAiEmbeddingsTaskSettings of(AzureOpenAiEmbeddingsTaskSettings originalSettings, AzureOpenAiEmbeddingsRequestTaskSettings requestSettings) {
        String userToUse = requestSettings.user() == null ? originalSettings.user : requestSettings.user();
        return new AzureOpenAiEmbeddingsTaskSettings(userToUse);
    }

    public AzureOpenAiEmbeddingsTaskSettings(@Nullable String user) {
        this.user = user;
    }

    public AzureOpenAiEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this.user = in.readOptionalString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.user != null) {
            builder.field("user", this.user);
        }
        builder.endObject();
        return builder;
    }

    public String user() {
        return this.user;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_AZURE_OPENAI_EMBEDDINGS;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.user);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureOpenAiEmbeddingsTaskSettings that = (AzureOpenAiEmbeddingsTaskSettings)o;
        return Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }
}

