/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.core.inference.results.TextEmbedding;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;

public class ServiceUtils {
    private static final String TEST_EMBEDDING_INPUT = "how big";

    public static <T> T removeAsType(Map<String, Object> sourceMap, String key, Class<T> type) {
        Object o = sourceMap.remove(key);
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new ElasticsearchStatusException("field [{}] is not of the expected type. The value [{}] cannot be converted to a [{}]", RestStatus.BAD_REQUEST, new Object[]{key, o, type.getSimpleName()});
    }

    public static Map<String, Object> removeFromMapOrThrowIfNull(Map<String, Object> sourceMap, String fieldName) {
        Map value = (Map)sourceMap.remove(fieldName);
        if (value == null) {
            throw new ElasticsearchStatusException("Missing required field [{}]", RestStatus.BAD_REQUEST, new Object[]{fieldName});
        }
        return value;
    }

    public static Map<String, Object> removeFromMapOrDefaultEmpty(Map<String, Object> sourceMap, String fieldName) {
        Map value = (Map)sourceMap.remove(fieldName);
        if (value == null) {
            return new HashMap<String, Object>();
        }
        return value;
    }

    public static String removeStringOrThrowIfNull(Map<String, Object> sourceMap, String key) {
        String value = ServiceUtils.removeAsType(sourceMap, key, String.class);
        if (value == null) {
            throw new ElasticsearchStatusException("Missing required field [{}]", RestStatus.BAD_REQUEST, new Object[]{key});
        }
        return value;
    }

    public static void throwIfNotEmptyMap(Map<String, Object> settingsMap, String serviceName) {
        if (settingsMap != null && !settingsMap.isEmpty()) {
            throw ServiceUtils.unknownSettingsError(settingsMap, serviceName);
        }
    }

    public static ElasticsearchStatusException unknownSettingsError(Map<String, Object> config, String serviceName) {
        return new ElasticsearchStatusException("Model configuration contains settings [{}] unknown to the [{}] service", RestStatus.BAD_REQUEST, new Object[]{config, serviceName});
    }

    public static String missingSettingErrorMsg(String settingName, String scope) {
        return Strings.format((String)"[%s] does not contain the required setting [%s]", (Object[])new Object[]{scope, settingName});
    }

    public static String invalidUrlErrorMsg(String url, String settingName, String settingScope) {
        return Strings.format((String)"[%s] Invalid url [%s] received for field [%s]", (Object[])new Object[]{settingScope, url, settingName});
    }

    public static String mustBeNonEmptyString(String settingName, String scope) {
        return Strings.format((String)"[%s] Invalid value empty string. [%s] must be a non-empty string", (Object[])new Object[]{scope, settingName});
    }

    public static String mustBeNonNonNull(String settingName, String scope) {
        return Strings.format((String)"[%s] Invalid value empty string. [%s] must be non-null", (Object[])new Object[]{scope, settingName});
    }

    public static String invalidValue(String settingName, String scope, String invalidType, String[] requiredValues) {
        Object[] copyOfRequiredValues = (String[])requiredValues.clone();
        Arrays.sort(copyOfRequiredValues);
        return Strings.format((String)"[%s] Invalid value [%s] received. [%s] must be one of [%s]", (Object[])new Object[]{scope, invalidType, settingName, String.join((CharSequence)", ", (CharSequence[])copyOfRequiredValues)});
    }

    public static String invalidSettingError(String settingName, String scope) {
        return Strings.format((String)"[%s] does not allow the setting [%s]", (Object[])new Object[]{scope, settingName});
    }

    public static URI convertToUri(@Nullable String url, String settingName, String settingScope, ValidationException validationException) {
        try {
            if (url == null) {
                return null;
            }
            return ServiceUtils.createUri(url);
        }
        catch (IllegalArgumentException ignored) {
            validationException.addValidationError(ServiceUtils.invalidUrlErrorMsg(url, settingName, settingScope));
            return null;
        }
    }

    public static URI createUri(String url) throws IllegalArgumentException {
        Objects.requireNonNull(url);
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(Strings.format((String)"unable to parse url [%s]", (Object[])new Object[]{url}), e);
        }
    }

    public static URI createOptionalUri(String url) {
        if (url == null) {
            return null;
        }
        return ServiceUtils.createUri(url);
    }

    public static SecureString extractRequiredSecureString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String requiredField = ServiceUtils.extractRequiredString(map, settingName, scope, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            return null;
        }
        return new SecureString(Objects.requireNonNull(requiredField).toCharArray());
    }

    public static SecureString extractOptionalSecureString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String optionalField = ServiceUtils.extractOptionalString(map, settingName, scope, validationException);
        if (!validationException.validationErrors().isEmpty() || optionalField == null) {
            return null;
        }
        return new SecureString(optionalField.toCharArray());
    }

    public static SimilarityMeasure extractSimilarity(Map<String, Object> map, String scope, ValidationException validationException) {
        return ServiceUtils.extractOptionalEnum(map, "similarity", scope, SimilarityMeasure::fromString, EnumSet.allOf(SimilarityMeasure.class), validationException);
    }

    public static String extractRequiredString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String requiredField = ServiceUtils.removeAsType(map, settingName, String.class);
        if (requiredField == null) {
            validationException.addValidationError(ServiceUtils.missingSettingErrorMsg(settingName, scope));
        } else if (requiredField.isEmpty()) {
            validationException.addValidationError(ServiceUtils.mustBeNonEmptyString(settingName, scope));
        }
        if (!validationException.validationErrors().isEmpty()) {
            return null;
        }
        return requiredField;
    }

    public static String extractOptionalString(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        String optionalField = ServiceUtils.removeAsType(map, settingName, String.class);
        if (optionalField != null && optionalField.isEmpty()) {
            validationException.addValidationError(ServiceUtils.mustBeNonEmptyString(settingName, scope));
        }
        if (!validationException.validationErrors().isEmpty()) {
            return null;
        }
        return optionalField;
    }

    public static Integer extractOptionalPositiveInteger(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        Integer optionalField = ServiceUtils.removeAsType(map, settingName, Integer.class);
        if (optionalField != null && optionalField <= 0) {
            validationException.addValidationError(ServiceUtils.mustBeAPositiveNumberErrorMessage(settingName, optionalField));
        }
        if (!validationException.validationErrors().isEmpty()) {
            return null;
        }
        return optionalField;
    }

    public static <E extends Enum<E>> E extractOptionalEnum(Map<String, Object> map, String settingName, String scope, EnumConstructor<E> constructor, EnumSet<E> validValues, ValidationException validationException) {
        String enumString = ServiceUtils.extractOptionalString(map, settingName, scope, validationException);
        if (enumString == null) {
            return null;
        }
        try {
            E createdEnum = constructor.apply(enumString);
            ServiceUtils.validateEnumValue(createdEnum, validValues);
            return createdEnum;
        }
        catch (IllegalArgumentException e) {
            String[] validValuesAsStrings = (String[])validValues.stream().map(value -> value.toString().toLowerCase(Locale.ROOT)).toArray(String[]::new);
            validationException.addValidationError(ServiceUtils.invalidValue(settingName, scope, enumString, validValuesAsStrings));
            return null;
        }
    }

    public static Boolean extractOptionalBoolean(Map<String, Object> map, String settingName, String scope, ValidationException validationException) {
        Boolean optionalField = ServiceUtils.removeAsType(map, settingName, Boolean.class);
        if (!validationException.validationErrors().isEmpty()) {
            return null;
        }
        return optionalField;
    }

    private static <E extends Enum<E>> void validateEnumValue(E enumValue, EnumSet<E> validValues) {
        if (!validValues.contains(enumValue)) {
            throw new IllegalArgumentException(Strings.format((String)"Enum value [%s] is not one of the acceptable values", (Object[])new Object[]{enumValue.toString()}));
        }
    }

    public static String mustBeAPositiveNumberErrorMessage(String settingName, int value) {
        if (value <= 0) {
            return "Invalid value [" + value + "]. [" + settingName + "] must be a positive integer";
        }
        throw new IllegalArgumentException("Value [" + value + "] is not a positive integer");
    }

    public static String parsePersistedConfigErrorMsg(String inferenceEntityId, String serviceName) {
        return Strings.format((String)"Failed to parse stored model [%s] for [%s] service, please delete and add the service again", (Object[])new Object[]{inferenceEntityId, serviceName});
    }

    public static ElasticsearchStatusException createInvalidModelException(Model model) {
        return new ElasticsearchStatusException(Strings.format((String)"The internal model was invalid, please delete the service [%s] with id [%s] and add it again.", (Object[])new Object[]{model.getConfigurations().getService(), model.getConfigurations().getInferenceEntityId()}), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }

    public static void getEmbeddingSize(Model model, InferenceService service, ActionListener<Integer> listener) {
        assert (model.getTaskType() == TaskType.TEXT_EMBEDDING);
        service.infer(model, null, List.of(TEST_EMBEDDING_INPUT), Map.of(), InputType.INGEST, InferenceAction.Request.DEFAULT_TIMEOUT, listener.delegateFailureAndWrap((delegate, r) -> {
            if (r instanceof TextEmbedding) {
                TextEmbedding embeddingResults = (TextEmbedding)r;
                try {
                    delegate.onResponse((Object)embeddingResults.getFirstEmbeddingSize());
                }
                catch (Exception e) {
                    delegate.onFailure((Exception)new ElasticsearchStatusException("Could not determine embedding size", RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
                }
            } else {
                delegate.onFailure((Exception)new ElasticsearchStatusException("Could not determine embedding size. Expected a result of type [text_embedding_service_results] got [" + r.getWriteableName() + "]", RestStatus.BAD_REQUEST, new Object[0]));
            }
        }));
    }

    public static SecureString apiKey(@Nullable ApiKeySecrets secrets) {
        return secrets == null ? new SecureString(new char[0]) : secrets.apiKey();
    }

    @FunctionalInterface
    public static interface EnumConstructor<E extends Enum<E>> {
        public E apply(String var1) throws IllegalArgumentException;
    }
}

