/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response;

import java.io.IOException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.XContentParser;

public class XContentUtils {
    public static void moveToFirstToken(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
    }

    public static void positionParserAtTokenAfterField(XContentParser parser, String field, String errorMsgTemplate) throws IOException {
        XContentParser.Token token = parser.nextToken();
        while (token != null && token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME && parser.currentName().equals(field)) {
                parser.nextToken();
                return;
            }
            token = parser.nextToken();
        }
        throw new IllegalStateException(Strings.format((String)errorMsgTemplate, (Object[])new Object[]{field}));
    }

    public static void consumeUntilObjectEnd(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        while (token != null && token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_OBJECT || token == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
            }
            token = parser.nextToken();
        }
    }

    private XContentUtils() {
    }
}

