/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.azureopenai;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.azureopenai.AzureOpenAiAccount;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.external.request.azureopenai.AzureOpenAiEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.external.request.azureopenai.AzureOpenAiRequest;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsModel;

public class AzureOpenAiEmbeddingsRequest
implements AzureOpenAiRequest {
    private static final String MISSING_AUTHENTICATION_ERROR_MESSAGE = "The request does not have any authentication methods set. One of [%s] or [%s] is required.";
    private final Truncator truncator;
    private final AzureOpenAiAccount account;
    private final Truncator.TruncationResult truncationResult;
    private final URI uri;
    private final AzureOpenAiEmbeddingsModel model;

    public AzureOpenAiEmbeddingsRequest(Truncator truncator, Truncator.TruncationResult input, AzureOpenAiEmbeddingsModel model) {
        this.truncator = Objects.requireNonNull(truncator);
        this.account = AzureOpenAiAccount.fromModel(model);
        this.truncationResult = Objects.requireNonNull(input);
        this.model = Objects.requireNonNull(model);
        this.uri = model.getUri();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        String requestEntity = Strings.toString((ToXContent)new AzureOpenAiEmbeddingsRequestEntity(this.truncationResult.input(), this.model.getTaskSettings().user(), this.model.getServiceSettings().dimensions(), this.model.getServiceSettings().dimensionsSetByUser()));
        ByteArrayEntity byteEntity = new ByteArrayEntity(requestEntity.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader((Header)new BasicHeader("Content-Type", XContentType.JSON.mediaType()));
        SecureString entraId = this.model.getSecretSettings().entraId();
        SecureString apiKey = this.model.getSecretSettings().apiKey();
        if (entraId != null && !entraId.isEmpty()) {
            httpPost.setHeader(RequestUtils.createAuthBearerHeader(entraId));
        } else if (apiKey != null && !apiKey.isEmpty()) {
            httpPost.setHeader((Header)new BasicHeader("api-key", apiKey.toString()));
        } else {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError(Strings.format((String)MISSING_AUTHENTICATION_ERROR_MESSAGE, (Object[])new Object[]{"api_key", "entra_id"}));
            throw validationException;
        }
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public Request truncate() {
        Truncator.TruncationResult truncatedInput = this.truncator.truncate(this.truncationResult.input());
        return new AzureOpenAiEmbeddingsRequest(this.truncator, truncatedInput, this.model);
    }

    @Override
    public boolean[] getTruncationInfo() {
        return (boolean[])this.truncationResult.truncated().clone();
    }
}

