/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import org.apache.http.client.protocol.HttpClientContext;
import org.elasticsearch.xpack.inference.external.http.retry.RetryingHttpSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceRequest;

public class SingleRequestManager {
    protected RetryingHttpSender requestSender;

    public SingleRequestManager(RetryingHttpSender requestSender) {
        this.requestSender = Objects.requireNonNull(requestSender);
    }

    public void execute(InferenceRequest inferenceRequest, HttpClientContext context) {
        if (SingleRequestManager.isNoopRequest(inferenceRequest) || inferenceRequest.hasCompleted()) {
            return;
        }
        inferenceRequest.getRequestCreator().create(inferenceRequest.getQuery(), inferenceRequest.getInput(), this.requestSender, inferenceRequest.getRequestCompletedFunction(), context, inferenceRequest.getListener()).run();
    }

    private static boolean isNoopRequest(InferenceRequest inferenceRequest) {
        return inferenceRequest.getRequestCreator() == null || inferenceRequest.getInput() == null || inferenceRequest.getListener() == null;
    }
}

