/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ListenerTimeouts;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RejectableTask;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;

class RequestTask
implements RejectableTask {
    private final AtomicBoolean finished = new AtomicBoolean();
    private final RequestManager requestCreator;
    private final String query;
    private final List<String> input;
    private final ActionListener<InferenceServiceResults> listener;

    RequestTask(RequestManager requestCreator, InferenceInputs inferenceInputs, @Nullable TimeValue timeout, ThreadPool threadPool, ActionListener<InferenceServiceResults> listener) {
        this.requestCreator = Objects.requireNonNull(requestCreator);
        this.listener = this.getListener(Objects.requireNonNull(listener), timeout, Objects.requireNonNull(threadPool));
        if (inferenceInputs instanceof QueryAndDocsInputs) {
            this.query = ((QueryAndDocsInputs)inferenceInputs).getQuery();
            this.input = ((QueryAndDocsInputs)inferenceInputs).getChunks();
        } else if (inferenceInputs instanceof DocumentsOnlyInput) {
            this.query = null;
            this.input = ((DocumentsOnlyInput)inferenceInputs).getInputs();
        } else {
            throw new IllegalArgumentException("Unsupported inference inputs type: " + inferenceInputs.getClass());
        }
    }

    private ActionListener<InferenceServiceResults> getListener(ActionListener<InferenceServiceResults> origListener, @Nullable TimeValue timeout, ThreadPool threadPool) {
        ActionListener notificationListener = ActionListener.wrap(result -> {
            this.finished.set(true);
            origListener.onResponse(result);
        }, e -> {
            this.finished.set(true);
            origListener.onFailure(e);
        });
        if (timeout == null) {
            return notificationListener;
        }
        return ListenerTimeouts.wrapWithTimeout((ThreadPool)threadPool, (TimeValue)timeout, (Executor)threadPool.executor("inference_utility"), (ActionListener)notificationListener, ignored -> notificationListener.onFailure((Exception)new ElasticsearchTimeoutException(Strings.format((String)"Request timed out waiting to be sent after [%s]", (Object[])new Object[]{timeout}), new Object[0])));
    }

    @Override
    public boolean hasCompleted() {
        return this.finished.get();
    }

    @Override
    public Supplier<Boolean> getRequestCompletedFunction() {
        return this::hasCompleted;
    }

    @Override
    public List<String> getInput() {
        return this.input;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public ActionListener<InferenceServiceResults> getListener() {
        return this.listener;
    }

    @Override
    public void onRejection(Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public RequestManager getRequestCreator() {
        return this.requestCreator;
    }
}

