/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;

abstract class BaseRequestManager
implements RequestManager {
    private final ThreadPool threadPool;
    private final String inferenceEntityId;
    private final Object rateLimitGroup;

    BaseRequestManager(ThreadPool threadPool, String inferenceEntityId, Object rateLimitGroup) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.inferenceEntityId = Objects.requireNonNull(inferenceEntityId);
        this.rateLimitGroup = Objects.requireNonNull(rateLimitGroup);
    }

    protected void execute(Runnable runnable) {
        this.threadPool.executor("inference_utility").execute(runnable);
    }

    @Override
    public String inferenceEntityId() {
        return this.inferenceEntityId;
    }

    @Override
    public Object rateLimitGrouping() {
        return this.rateLimitGroup;
    }
}

