/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.sender.BaseRequestManager;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiModel;

public abstract class AzureOpenAiRequestManager
extends BaseRequestManager {
    protected AzureOpenAiRequestManager(ThreadPool threadPool, AzureOpenAiModel model) {
        super(threadPool, model.getInferenceEntityId(), RateLimitGrouping.of(model));
    }

    record RateLimitGrouping(int resourceNameHash, int deploymentIdHash) {
        public static RateLimitGrouping of(AzureOpenAiModel model) {
            Objects.requireNonNull(model);
            return new RateLimitGrouping(model.rateLimitServiceSettings().resourceName().hashCode(), model.rateLimitServiceSettings().deploymentId().hashCode());
        }
    }
}

